/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeReservationParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AddServicesQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AddAncillaryFeesToAdditionalServiceRequestProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map gdsTravellerIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.GDS_TRAVELLERS_IDS);
        boolean hasAncillaryFees = gdsTravellerIds.values().stream().flatMap(gdsTraveller -> gdsTraveller.getAncillaryFees().stream()).findAny().isPresent();
        if (!hasAncillaryFees) {
            return;
        }
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        this.addAncillaryFeesToRequest((SirenaRequest<AddServicesQuery>)request, gdsTravellerIds, answer, flight);
    }

    private void addAncillaryFeesToRequest(SirenaRequest<AddServicesQuery> request, Map<String, GdsTraveller> gdsTravellerIds, OrderAnswer answer, Flight flight) {
        Map<GdsTraveller, String> invertedGdsTravellerIds = gdsTravellerIds.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        for (Map.Entry<GdsTraveller, String> gdsTravellerId : invertedGdsTravellerIds.entrySet()) {
            for (AncillaryFeeReservationParameters ancillaryFeeParams : gdsTravellerId.getKey().getAncillaryFees()) {
                AncillaryFee ancillaryFee = this.findAncillaryFee(flight.getAncillaryFees(), ancillaryFeeParams.getGdsId());
                if (ancillaryFee == null || ancillaryFee.getGdsId() == null) {
                    throw Xeption.forDeveloper((String)"can't find ancillaryFee by gdsUid = ", (Object[])new Object[]{ancillaryFeeParams.getGdsId()});
                }
                String[] gdsId = ancillaryFeeParams.getGdsId().split("\\|");
                if (gdsId.length < 4) {
                    throw Xeption.forDeveloper((String)"wrong gdsId for ancillaryFee = ", (Object[])new Object[]{ancillaryFeeParams.getGdsId()});
                }
                String rfisc = gdsId[0];
                String rfic = gdsId[1];
                String emd = gdsId[2];
                String serviceType = gdsId[3];
                for (Integer segmentNmb : ancillaryFee.getSegmentNumbers()) {
                    String answerSegmentId = answer.getPnr().getSegments().getSegments().get(segmentNmb).getId();
                    if (TextUtil.isBlank((String)answerSegmentId)) {
                        throw Xeption.forDeveloper((String)"can't find segment number for ancillaryFee - ", (Object[])new Object[]{ancillaryFeeParams.getGdsId()});
                    }
                    Svc svc = new Svc();
                    svc.setPassengerId(gdsTravellerId.getValue());
                    svc.setSegmentId(answerSegmentId);
                    svc.setRfic(rfic);
                    svc.setRfisc(rfisc);
                    svc.setEmd(emd);
                    svc.setServiceType(serviceType);
                    svc.setQtty(Integer.toString(ancillaryFeeParams.getQuantity()));
                    ((AddServicesQuery)request.getQuery()).getSvcs().add(svc);
                }
            }
        }
    }

    private AncillaryFee findAncillaryFee(List<AncillaryFee> flightAncillaryFees, String gdsId) {
        return flightAncillaryFees.stream().filter(fee -> gdsId.equals(fee.getGdsId())).findFirst().orElse(null);
    }
}

