/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.xtrip.common.gds.model.AircraftSeatReservationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AddServicesQuery;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;

public class AddSeatsReservationsToAdditionalServiceRequestProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map gdsTravellerIds = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.GDS_TRAVELLERS_IDS);
        boolean hasSeatsReservations = gdsTravellerIds.values().stream().flatMap(gdsTraveller -> gdsTraveller.getSeatsReservationParameters().stream()).findAny().isPresent();
        if (!hasSeatsReservations) {
            return;
        }
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        this.addSeatsReservationsToAdditionalServiceRequest(gdsTravellerIds, answer, (SirenaRequest<AddServicesQuery>)request);
    }

    private void addSeatsReservationsToAdditionalServiceRequest(Map<String, GdsTraveller> gdsTravellerIds, OrderAnswer answer, SirenaRequest<AddServicesQuery> request) {
        List<Pnr.Segments.Segment> segments = answer.getPnr().getSegments().getSegments();
        for (Map.Entry<String, GdsTraveller> gdsTravellerIdEntry : gdsTravellerIds.entrySet()) {
            for (AircraftSeatReservationParameters params : gdsTravellerIdEntry.getValue().getSeatsReservationParameters()) {
                Svc svc = new Svc();
                svc.setPassengerId(gdsTravellerIdEntry.getKey());
                svc.setSegmentId(segments.get(Integer.parseInt(params.getSegmentId())).getId());
                svc.setRfisc(SirenaCustomPropertiesHelper.getSvcRfisc((AircraftSeatReservationParameters)params));
                svc.setServiceType(SirenaCustomPropertiesHelper.getSvcServiceType((AircraftSeatReservationParameters)params));
                svc.setEmd("EMD-A");
                svc.setSsr("SEAT");
                svc.setText(params.getSeatNumber());
                ((AddServicesQuery)request.getQuery()).getSvcs().add(svc);
            }
        }
    }
}

