/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.createReservation.AddFfInfoHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.AddFfInfoQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;

public class AddTravellerBonusCardsProcessor
extends BaseProcessor {
    private static final CodeTranslator CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name(), CodeSystem.CRT.name()});

    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        AddFfInfoQuery query = (AddFfInfoQuery)request.getQuery();
        HashSet<Traveller> processed = new HashSet<Traveller>();
        for (Product product : AirProductHelper.getProducts((Reservation)reservation)) {
            if (!processed.add(product.getTraveller()) || product.getTraveller().getAirlineBonusCards().isEmpty()) continue;
            for (BookingAirlineBonusCard card : product.getTraveller().getAirlineBonusCards()) {
                AddFfInfoQuery.Passenger passenger = AddFfInfoHelper.buildPassenger(product);
                AddFfInfoQuery.Passenger.FreqFlierId freqFlierId = new AddFfInfoQuery.Passenger.FreqFlierId();
                freqFlierId.setValue(card.getNumber());
                freqFlierId.setIssuedBy(AddTravellerBonusCardsProcessor.getNativeCode(card.getAirline()));
                passenger.setFreqFlierId(freqFlierId);
                query.getPassengers().add(passenger);
            }
        }
    }

    public static <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return CODE_TRANSLATOR.getNativeCode(ref);
    }
}

