/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsBookabilityItem;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.bookability.GdsBookability;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaGate;
import com.gridnine.xtrip.server.ibus.components.AdviceOnExceptionCallback;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class BookabilitiesBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AdviceOnExceptionCallback callback = (AdviceOnExceptionCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.ADVICE_ON_EXCEPTION_CALLBACK);
        Throwable e = callback.getException();
        String msg = null;
        if (e instanceof SeatsNotConfirmedException) {
            SeatsNotConfirmedException x = (SeatsNotConfirmedException)e;
            String string = msg = x.getAdminMessage() != null ? x.getAdminMessage().toString() : null;
            if (msg == null) {
                String string2 = msg = x.getEndUserMessage() != null ? x.getEndUserMessage().toString() : x.getMessage();
            }
        }
        if (!StringUtils.isBlank(msg)) {
            GdsReservationCreationParameters params = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
            GdsBookabilityItem bi = GdsBookability.buildBookabilityItem((Flight)params.getFlight(), (String)msg);
            List transactions = (List)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_TRANSACTIONS);
            Document doc = this.buildDocument(transactions);
            bi.setTraceData(doc.getContent());
            ctx.putObject((Enum)IBusGdsContextKeys.GDS_BOOKABILITY_ITEMS, Collections.singletonList(bi));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDocument(List<SirenaGate.GateTransaction> transactions) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             XMLStreamWriter xsw = XSUtil.wrapForPrettyPrinting((XMLStreamWriter)XSUtil.getXMLOutputFactory().createXMLStreamWriter(baos));){
            xsw.writeStartElement("ws-transactions");
            for (SirenaGate.GateTransaction transaction : transactions) {
                xsw.writeStartElement("ws-transaction");
                xsw.writeStartElement("request");
                xsw.flush();
                baos.write(transaction.queryData);
                baos.flush();
                xsw.writeEndElement();
                xsw.writeStartElement("response");
                xsw.flush();
                baos.write(transaction.answerData);
                baos.flush();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
        Document document = new Document();
        document.setContent(baos.toByteArray());
        document.setCheckSum(DigestUtils.md5Hex((byte[])document.getContent()));
        document.setContentType(ContentType.XML);
        document.setCreated(new Date());
        return document;
    }
}

