/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.RegnumAndSurname;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.BookingAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookingCreateResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        BookingAnswer answer = (BookingAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = new Reservation();
        reservation.getGdsNameInfo().setOnlineGdsAccount(gdsAccountCtr.toReference());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_CYRILLIC, (String)answer.getPnr().getRegnum());
        for (Pnr.Passengers.Passenger passenger : answer.getPnr().getPassengers().getPassengers()) {
            if (passenger.getLeadPass() == null || !passenger.getLeadPass().booleanValue()) continue;
            Passport passport = new Passport();
            passport.setLastName(passenger.getSurname());
            Traveller traveller = new Traveller();
            traveller.setPassport(passport);
            Product product = new Product();
            product.setTraveller(traveller);
            reservation.getProducts().add(product);
            break;
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
        RegnumAndSurname rns = new RegnumAndSurname();
        rns.setRegnum(answer.getPnr().getRegnum());
        for (Pnr.Passengers.Passenger passenger : answer.getPnr().getPassengers().getPassengers()) {
            if (passenger.getLeadPass() == null || !passenger.getLeadPass().booleanValue()) continue;
            rns.setSurname(passenger.getSurname());
            break;
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.REGNUM_AND_SURNAME, (Object)rns);
        GdsReservationCreationParameters gdsReservationCreationParameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        HashMap<String, GdsTraveller> gdsTravellers = new HashMap<String, GdsTraveller>();
        Map<String, List<GdsTraveller>> data = gdsReservationCreationParameters.getGdsTravellers().stream().collect(Collectors.groupingBy(gdst -> SirenaHelper.getUniqueTravellerName((Traveller)((Traveller)CollectionUtil.find((Iterable)travellers, (String)gdst.getTravellerUid())))));
        for (List<GdsTraveller> slice : data.values()) {
            int sliceIdx = 0;
            for (GdsTraveller gdsTraveller : slice) {
                Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
                Pnr.Passengers.Passenger passenger = SirenaServerHelper.getPassenger(answer.getPnr(), traveller, sliceIdx);
                gdsTraveller.setDiscountDocumentCode(passenger.getDoccodeDisc());
                gdsTraveller.setDiscountDocumentNumber(passenger.getDocDisc());
                gdsTravellers.put(passenger.getId(), gdsTraveller);
                ++sliceIdx;
            }
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.GDS_TRAVELLERS_IDS, gdsTravellers);
    }
}

