/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SegmentSpecialServiceRequest;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.AirlineDiscountCard;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ProfileKeyContactPerson;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.BookingQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class BookingQueryBuilder
extends BaseProcessor {
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"dd.MM.yy");

    public void process(MessageContext ctx) {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        this.substitutePassengerType(parameters, flight);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Customer customer = (Customer)ctx.getObject((Enum)IBusMidofficeContextKeys.CUSTOMER);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(flight, parameters.getGdsTravellers(), travellers, customer, salesContext));
    }

    private void substitutePassengerType(GdsReservationCreationParameters parameters, Flight flight) {
        if (flight.getTripartiteContractDetails() != null && flight.getTripartiteContractDetails().getSubstitutePassengerType() != null) {
            for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
                gdsTraveller.setPassengerType(flight.getTripartiteContractDetails().getSubstitutePassengerType());
            }
        }
    }

    private SirenaRequest<BookingQuery> buildRequest(Flight flight, Collection<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, Customer customer, SalesContext salesContext) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(flight, gdsTravellers, travellers, customer, salesContext));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private BookingQuery buildQuery(Flight flight, Collection<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, Customer customer, SalesContext salesContext) {
        HashMap<String, String> segIds = new HashMap<String, String>();
        HashMap<String, String> passIds = new HashMap<String, String>();
        BookingQuery query = new BookingQuery();
        this.buildRoute(query, flight, segIds);
        this.buildPassengers(query, flight, gdsTravellers, travellers, passIds);
        this.buildParameters(query, flight, customer, salesContext, gdsTravellers, travellers);
        this.buildSpecialServices(query, gdsTravellers, segIds, passIds);
        BookingQuery.AnswerParams ap = query.getAnswerParams();
        if (ap == null) {
            ap = new BookingQuery.AnswerParams();
            query.setAnswerParams(ap);
        }
        ap.setShowTts(Boolean.TRUE);
        return query;
    }

    private void buildSpecialServices(BookingQuery query, Collection<GdsTraveller> gdsTravellers, Map<String, String> segIds, Map<String, String> passIds) {
        for (GdsTraveller gdsTraveller : gdsTravellers) {
            for (SegmentSpecialServiceRequest rq : gdsTraveller.getSsrs()) {
                SirenaServerHelper.addSsrSectionIfMissing(query);
                BookingQuery.SpecialServices.Ssrs.Ssr ssr = new BookingQuery.SpecialServices.Ssrs.Ssr();
                ssr.setType(SirenaHelper.getNativeCode((DictionaryReference)rq.getSpecialServiceRequest().getType()));
                ssr.setSegId(segIds.get(rq.getSegmentUid()));
                ssr.setPassId(passIds.get(gdsTraveller.getUid()));
                if (!StringUtils.isBlank((String)rq.getSpecialServiceRequest().getRequestFreeText())) {
                    ssr.setText(rq.getSpecialServiceRequest().getRequestFreeText());
                }
                query.getSpecialServices().getSsrs().getSsrs().add(ssr);
            }
        }
    }

    private void buildParameters(BookingQuery query, Flight flight, Customer customer, SalesContext salesContext, Collection<GdsTraveller> gdsTravellers, Collection<Traveller> travellers) {
        BookingQuery.RequestParams rp;
        boolean contactSet = false;
        if (customer != null) {
            for (Communication comm : customer.getCommunications()) {
                switch (comm.getType()) {
                    case HOME_PHONE: 
                    case WORK_PHONE: 
                    case MOBILE: {
                        BookingQuery.Contacts.Contact contact = new BookingQuery.Contacts.Contact();
                        contact.setValue(SirenaHelper.buildFullPhoneNumber((Communication)comm));
                        contact.setType(SirenaHelper.native2CommunicationType((Communication)comm));
                        if (query.getContacts() == null) {
                            query.setContacts(new BookingQuery.Contacts());
                        }
                        query.getContacts().getContacts().add(contact);
                        contactSet = true;
                        break;
                    }
                    case EMAIL: {
                        BookingQuery.Contacts.Contact email = new BookingQuery.Contacts.Contact();
                        email.setValue(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
                        if (query.getContacts() == null) {
                            query.setContacts(new BookingQuery.Contacts());
                        }
                        query.getContacts().getEmails().add(email);
                        break;
                    }
                }
            }
        }
        if (!contactSet) {
            block12: for (GdsTraveller gdsTraveller : gdsTravellers) {
                Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
                for (Communication comm : traveller.getCommunications()) {
                    switch (comm.getType()) {
                        case HOME_PHONE: 
                        case WORK_PHONE: 
                        case MOBILE: {
                            BookingQuery.Contacts.Contact passengerContact = new BookingQuery.Contacts.Contact();
                            passengerContact.setValue(SirenaHelper.buildFullPhoneNumber((Communication)comm));
                            passengerContact.setType(SirenaHelper.native2CommunicationType((Communication)comm));
                            passengerContact.setComment(TextUtil.buildFullName((PersonalName)traveller.getPassport()));
                            if (query.getContacts() == null) {
                                query.setContacts(new BookingQuery.Contacts());
                            }
                            query.getContacts().getContacts().add(passengerContact);
                            break block12;
                        }
                    }
                }
            }
        }
        EntityReference agencyRef = salesContext.getAgency();
        EntityContainer agencyContainer = EntityStorage.get().resolve(agencyRef);
        Organization agency = (Organization)agencyContainer.getEntity();
        List comms = agency.getCommunications();
        List keyContacts = agency.getKeyContacts();
        String agencyPhone = null;
        String agencyEmail = null;
        block14: for (ProfileKeyContactPerson pkcp : keyContacts) {
            EntityReference personRef = pkcp.getPerson();
            EntityContainer personCtr = EntityStorage.get().resolve(personRef);
            Person person = (Person)personCtr.getEntity();
            for (Communication comm : person.getCommunications()) {
                if (comm.getType() != CommunicationType.WORK_PHONE) continue;
                agencyPhone = SirenaHelper.buildFullPhoneNumber((Communication)comm);
                continue block14;
            }
        }
        for (Communication comm : comms) {
            switch (comm.getType()) {
                case WORK_PHONE: {
                    if (agencyPhone != null) break;
                    agencyPhone = SirenaHelper.buildFullPhoneNumber((Communication)comm);
                    break;
                }
                case EMAIL: {
                    if (agencyEmail != null) break;
                    agencyEmail = ProfileHelper.normalizeCommunicationPart((String)comm.getSense());
                    break;
                }
            }
        }
        if (agencyPhone != null) {
            L10nString agencyL10nName = agency.getShortName();
            Map values = agencyL10nName.getValues();
            String agencyName = (String)values.get(LocaleHelper.getLocale((String)"ru"));
            if (agencyName == null && (agencyName = (String)values.get(LocaleHelper.getLocale((String)"en"))) == null) {
                agencyName = agencyL10nName.toString();
            }
            BookingQuery.Contacts.Contact agencyContact = new BookingQuery.Contacts.Contact();
            agencyContact.setValue(agencyPhone);
            agencyContact.setType("agency");
            if (agencyName != null) {
                agencyContact.setComment(agencyName);
            }
            if (query.getContacts() == null) {
                query.setContacts(new BookingQuery.Contacts());
            }
            query.getContacts().getContacts().add(agencyContact);
        }
        if (agencyEmail != null) {
            BookingQuery.Contacts.Contact agencyEmailContact = new BookingQuery.Contacts.Contact();
            agencyEmailContact.setValue(agencyEmail);
            agencyEmailContact.setType("agency");
            if (query.getContacts() == null) {
                query.setContacts(new BookingQuery.Contacts());
            }
            query.getContacts().getContacts().add(agencyEmailContact);
        }
        if ((rp = query.getRequestParams()) == null) {
            rp = new BookingQuery.RequestParams();
            query.setRequestParams(rp);
        }
        rp.setTickSer("\u042d\u0411\u041c");
        String requestedBrands = SirenaCustomPropertiesHelper.getRequestedBrands((Flight)flight);
        Map brandIdSubstitutes = Optional.ofNullable(flight.getTripartiteContractDetails()).map(TripartiteContractDetails::getSubstituteBrandIds).orElse(Collections.emptyMap());
        if (!StringUtils.isBlank((String)requestedBrands)) {
            BookingQuery.Brand brand = new BookingQuery.Brand();
            brand.setBrand(brandIdSubstitutes.getOrDefault(requestedBrands, requestedBrands));
            rp.getBrand().add(brand);
        } else if (flight.getSegmentTariffs().stream().anyMatch(fst -> !StringUtils.isBlank((String)SirenaCustomPropertiesHelper.getBrand((FlightSegmentTariff)fst)))) {
            int segId = 1;
            boolean isSegIdNeeded = flight.getSegmentTariffs().size() > 1;
            for (FlightSegmentTariff fst2 : flight.getSegmentTariffs()) {
                String brandId;
                String segBrand = SirenaCustomPropertiesHelper.getBrand((FlightSegmentTariff)fst2);
                if (StringUtils.isBlank((String)segBrand)) continue;
                BookingQuery.Brand brand = new BookingQuery.Brand();
                if (segBrand.contains(".")) {
                    String[] array = segBrand.split("\\.");
                    brandId = array[array.length - 1];
                } else {
                    brandId = segBrand;
                }
                brand.setBrand(brandIdSubstitutes.getOrDefault(brandId, brandId));
                if (isSegIdNeeded) {
                    brand.setSegId(Integer.toString(segId));
                    ++segId;
                }
                rp.getBrand().add(brand);
            }
        }
    }

    private void buildPassengers(BookingQuery query, Flight flight, Collection<GdsTraveller> gdsTravellers, Collection<Traveller> travellers, Map<String, String> passIds) {
        List slicedGdsTravellers = CollectionUtil.groupBy(gdsTravellers, (gdsTraveller1, gdsTraveller2) -> {
            Traveller traveller1 = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller1.getTravellerUid());
            Traveller traveller2 = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller2.getTravellerUid());
            return SirenaHelper.getUniqueTravellerName((Traveller)traveller1).equals(SirenaHelper.getUniqueTravellerName((Traveller)traveller2));
        });
        int id = 1;
        for (List slice : slicedGdsTravellers) {
            for (int i = 0; i < slice.size(); ++i) {
                EntityReference person;
                GdsTraveller gdsTraveller = (GdsTraveller)slice.get(i);
                Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
                BookingQuery.Passenger passenger = new BookingQuery.Passenger();
                passenger.setId(Integer.toString(id));
                passIds.put(gdsTraveller.getUid(), Integer.toString(id));
                passenger.setFamily(SirenaHelper.buildSurname((Traveller)traveller));
                passenger.setName(SirenaHelper.buildName((Traveller)traveller, (int)i));
                passenger.setAge(DTF.format(traveller.getPassport().getBirthday()));
                passenger.setSex(Gender.FEMALE == traveller.getPassport().getGender() ? "female" : "male");
                passenger.setCategory(BookingQueryBuilder.getPassengerCategoryCode(gdsTraveller, traveller, flight.getFares(), ((FlightSegment)((FlightSegmentTariff)flight.getSegmentTariffs().get(0)).getSegments().get(0)).getDateBegin()));
                passenger.setDoccode(SirenaHelper.idCardType2str((PassportType)traveller.getPassport().getType()));
                passenger.setDoc(SirenaHelper.fixDocNumberForPNR((String)traveller.getPassport().getNumber()));
                if (BookingQueryBuilder.getExpired(traveller.getPassport(), flight) != null) {
                    passenger.setPspexpire(DTF.format(BookingQueryBuilder.getExpired(traveller.getPassport(), flight)));
                }
                if (traveller.getPassport().getCitizenship() != null) {
                    passenger.setNationality(SirenaHelper.getNativeCode((DictionaryReference)traveller.getPassport().getCitizenship()));
                }
                for (Communication comm : traveller.getCommunications()) {
                    BookingQueryBuilder.setContact(passenger, comm);
                }
                Map discountCards = flight.getAirlineDiscountCards();
                AirlineDiscountCard card = (AirlineDiscountCard)discountCards.get(person = traveller.getPassenger());
                if (card != null) {
                    passenger.setDoccodeDisc(card.getCode());
                    passenger.setDocDisc(card.getNumber());
                }
                query.getPassengers().add(passenger);
                ++id;
            }
        }
    }

    private static Date getExpired(Passport passport, Flight flight) {
        List segments = FlightHelper.getSegments((Flight)flight);
        Date lastSegmentStartDate = ((FlightSegment)segments.get(segments.size() - 1)).getDateBegin();
        switch (passport.getType()) {
            case INTERNAL: 
            case BIRTHDAY_NOTIFICATION: {
                return MiscUtil.addYearsToDate((Date)lastSegmentStartDate, (int)1);
            }
        }
        return passport.getExpired();
    }

    private static void setContact(BookingQuery.Passenger passenger, Communication comm) {
        BookingQuery.Passenger.Contact contact = null;
        switch (comm.getType()) {
            case HOME_PHONE: 
            case WORK_PHONE: 
            case MOBILE: 
            case FAX: 
            case AGENCY: 
            case HOTEL: {
                contact = new BookingQuery.Passenger.Contact();
                contact.setValue(SirenaHelper.buildFullPhoneNumber((Communication)comm));
                passenger.getContacts().add(contact);
                break;
            }
            case EMAIL: {
                contact = new BookingQuery.Passenger.Contact();
                contact.setValue(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()).toUpperCase());
                passenger.getContacts().add(contact);
                break;
            }
        }
        if (contact != null) {
            contact.setType(SirenaHelper.native2CommunicationType((Communication)comm));
            if (!TextUtil.isBlank((String)comm.getRemarks()) && comm.getType() != CommunicationType.EMAIL) {
                contact.setComment(comm.getRemarks());
            }
        }
    }

    private static String getPassengerCategoryCode(GdsTraveller gdsTraveller, Traveller traveller, List<FlightFare> fares, Date baseAgeDate) {
        boolean isChild = DictHelper.isChildPassengerType((DictionaryReference)gdsTraveller.getPassengerType());
        for (FlightFare fare : fares) {
            String priceCode;
            if (!MiscUtil.equals((Object)fare.getPassengerType(), (Object)gdsTraveller.getPassengerType()) || (priceCode = SirenaCustomPropertiesHelper.getPriceCode((FlightFare)fare)) == null) continue;
            return priceCode;
        }
        if (isChild) {
            return traveller.getPassport() != null && BookingQueryBuilder.getAgeInMonths(baseAgeDate, traveller.getPassport().getBirthday()) < 24 ? "\u0420\u0412\u0413" : "\u0420\u0411\u0413";
        }
        return SirenaHelper.getNativeCode((DictionaryReference)gdsTraveller.getPassengerType());
    }

    private static int getAgeInMonths(Date baseDate, Date birthDate) {
        Calendar baseCldr = Calendar.getInstance();
        baseCldr.setTime(baseDate);
        Calendar bdCldr = Calendar.getInstance();
        bdCldr.setTime(birthDate);
        int result = (baseCldr.get(1) - bdCldr.get(1)) * 12 + baseCldr.get(2) - bdCldr.get(2);
        if (bdCldr.get(2) > baseCldr.get(2) || bdCldr.get(2) == baseCldr.get(2) && bdCldr.get(5) > baseCldr.get(5)) {
            return result - 1;
        }
        return result;
    }

    private void buildRoute(BookingQuery query, Flight flight, Map<String, String> segIds) {
        DictionaryReference prevLocation = null;
        int id = 1;
        int jointId = 0;
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (prevLocation != null && !prevLocation.equals((Object)seg.getLocationBegin())) {
                    BookingQuery.LandSegment landSegment = new BookingQuery.LandSegment();
                    landSegment.setId(Integer.toString(id));
                    landSegment.setPoint1(SirenaHelper.getNativeCode(prevLocation));
                    landSegment.setPoint2(SirenaHelper.getNativeCode((DictionaryReference)seg.getLocationBegin()));
                    query.getSegments().add(landSegment);
                    ++id;
                }
                if (seg.isStarting()) {
                    ++jointId;
                }
                BookingQuery.Segment segment = new BookingQuery.Segment();
                segment.setId(Integer.toString(id));
                segment.setJointId(Integer.toString(jointId));
                segIds.put(seg.getUid(), Integer.toString(id));
                query.getSegments().add(segment);
                segment.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)seg.getLocationBegin()));
                segment.setArrival(SirenaHelper.getNativeCode((DictionaryReference)seg.getLocationEnd()));
                segment.setDate(DTF.format(seg.getDateBegin()));
                segment.setSubclass(seg.getBookingClass());
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)seg.getAirline()));
                segment.setNum(seg.getFlightNumber());
                prevLocation = seg.getLocationEnd();
                ++id;
            }
        }
    }
}

