/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AircraftSeatReservationParameters;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LuggageUnits;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaModelHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class OrderResponseParser
extends BaseProcessor {
    private static final PeriodFormatter PF_FLIGHT_TIME = new PeriodFormatterBuilder().appendHours().appendSeparator(":").appendMinutes().toFormatter();

    private static void copyLostInfo(Flight flight, Product prod) {
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                FlightSegment fSeg = SirenaHelper.findMatchingSegment((Flight)flight, (Segment)seg);
                if (fSeg == null) continue;
                seg.setStarting(fSeg.isStarting());
                for (FareInfo fareInfo : fSeg.getFareInfos()) {
                    if (!MiscUtil.equals((Object)fareInfo.getPassengerType(), (Object)prod.getPassengerType())) continue;
                    seg.setRemarksSearchContext(fareInfo.getRemarksSearchContext());
                }
                seg.addTechStopInfos((Collection)fSeg.getTechStopInfos());
            }
        }
    }

    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        String pult = (String)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER_PULT);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Map gdsTravellers = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.GDS_TRAVELLERS_IDS);
        Reservation reservation = this.parseReservation(answer, (EntityContainer<SirenaGdsAccount>)accountCtr, parameters, travellers, gdsParameters, flight, pult, gdsTravellers);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private String getLocationCode(Pnr.Segments.Segment.Location location) {
        if (location == null) {
            return null;
        }
        String result = location.getAirport();
        return TextUtil.isBlank((String)result) ? location.getCity() : result;
    }

    private Reservation parseReservation(OrderAnswer answer, EntityContainer<SirenaGdsAccount> accountCtr, GdsReservationCreationParameters parameters, Collection<Traveller> travellers, GDSParameters gdsParameters, Flight flight, String pult, Map<String, GdsTraveller> gdsTravellers) throws Exception {
        GdsName gdsName = ((SirenaGdsAccount)accountCtr.getEntity()).getGds();
        Reservation res = new Reservation();
        CommonReservationGdsNameInfoHelper.setBookingPcc((Reservation)res, (GdsName)GdsName.SIRENA, (String)pult);
        res.getGdsNameInfo().setOnlineGdsAccount(accountCtr.toReference());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN, (String)answer.getLatinRegnum());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)res, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_CYRILLIC, (String)answer.getPnr().getRegnum());
        res.setPricingDate(new Date());
        Pnr.Passengers.Passenger leadPassenger = answer.getPnr().getPassengers().getPassengers().stream().filter(p -> Boolean.TRUE.equals(p.getLeadPass())).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"lead pass not found", (Object[])new Object[0]));
        res.setSireanLeadPass(leadPassenger.getSurname());
        List<Pnr.Segments.Segment> segmentList = answer.getPnr().getSegments().getSegments();
        HashMap<String, Pnr.Segments.Segment> segments = new HashMap<String, Pnr.Segments.Segment>();
        for (Pnr.Segments.Segment segment : segmentList) {
            segments.put(segment.getId(), segment);
        }
        HashMap mainProductPrices = new HashMap();
        HashMap mcoProductPrices = new HashMap();
        for (Pnr.Prices.Price price : answer.getPnr().getPrices().getPrices()) {
            if (TextUtil.nonBlank((String)price.getSvcId())) {
                if (!mcoProductPrices.containsKey(price.getTicket())) {
                    mcoProductPrices.put(price.getTicket(), new ArrayList());
                }
                ((List)mcoProductPrices.get(price.getTicket())).add(price);
                continue;
            }
            if (!mainProductPrices.containsKey(price.getTicket())) {
                mainProductPrices.put(price.getTicket(), new ArrayList());
            }
            ((List)mainProductPrices.get(price.getTicket())).add(price);
        }
        for (List priceGroup : mainProductPrices.values()) {
            priceGroup.sort((p1, p2) -> MiscUtil.compare((Comparable)((Object)p1.getSegmentId()), (Comparable)((Object)p2.getSegmentId())));
            GdsTraveller gdsTraveller = gdsTravellers.get(((Pnr.Prices.Price)priceGroup.get(0)).getPassengerId());
            Traveller traveller = (Traveller)CollectionUtil.find(travellers, (String)gdsTraveller.getTravellerUid());
            Product product = new Product();
            product.setSalesOriginProvider(SalesOriginProvider.SIRENA);
            product.setSalesOriginContent(SalesOriginContent.SIRENA);
            product.setPcc(pult.substring(0, 4));
            product.setProductCategory(ProductCategory.AIR);
            product.setGdsCurrency(DictHelper.getEquivCurrency());
            product.setPassengerType(gdsTraveller.getPassengerType());
            product.setTraveller(traveller);
            product.setTariffType(TariffType.REGULAR);
            product.setTravellerGdsId(((Pnr.Prices.Price)priceGroup.get(0)).getPassengerId());
            if (!StringUtils.isBlank((String)((Pnr.Prices.Price)priceGroup.get(0)).getTourCode())) {
                product.setTourCode(((Pnr.Prices.Price)priceGroup.get(0)).getTourCode());
            }
            product.setErsp(answer.getPnr().getErsp());
            product.setPenaltiesInfo((PenaltiesInfo)flight.getPenaltiesInfos().get(gdsTraveller.getPassengerType()));
            product.setDiscountDocumentCode(gdsTraveller.getDiscountDocumentCode());
            product.setDiscountDocumentNumber(gdsTraveller.getDiscountDocumentNumber());
            for (Pnr.Prices.Price price : priceGroup) {
                Pnr.Segments.Segment segment = (Pnr.Segments.Segment)segments.get(price.getSegmentId());
                if (segment == null) continue;
                Segment s = new Segment();
                s.setGdsId(price.getSegmentId());
                if (StringUtils.isBlank((String)product.getGdsId())) {
                    product.setGdsId(price.getPassengerId());
                }
                SegmentTariff st = new SegmentTariff();
                product.getSegmentTariffs().add(st);
                this.copySegments(segment, s, price, product, flight, st, (DictionaryReference<PassengerType>)gdsTraveller.getPassengerType());
            }
            if (gdsParameters.getValidatingCarrier() != null) {
                product.setCarrier(gdsParameters.getValidatingCarrier());
            }
            OrderResponseParser.copyLostInfo(parameters.getFlight(), product);
            product.setReservation(res);
            res.getProducts().add(product);
        }
        if (answer.getPnr().getSvcs() != null) {
            List<Svc> svcList = answer.getPnr().getSvcs().getSvcs();
            for (String ticketNumber : mcoProductPrices.keySet()) {
                List<Svc> mcoSvcList;
                Pnr.Prices.Price mcoPrice = (Pnr.Prices.Price)((List)mcoProductPrices.get(ticketNumber)).get(0);
                if (mcoPrice == null || (mcoSvcList = answer.getPnr().getSvcs().getSvcs().stream().filter(svc -> mcoPrice.getSvcId().equals(svc.getId())).collect(Collectors.toList())).isEmpty()) continue;
                MiscUtil.Pair<Product, Product> mcoPair = this.buildMco(mcoSvcList, res, gdsParameters, pult, answer, gdsName);
                Product mco = (Product)mcoPair.getFirst();
                Product mainProduct = (Product)mcoPair.getSecond();
                if (!StringUtils.isBlank((String)mcoPrice.getTourCode())) {
                    mco.setTourCode(mcoPrice.getTourCode());
                }
                SegmentTariff st = (SegmentTariff)mco.getSegmentTariffs().get(0);
                for (Pnr.Prices.Price price : (List)mcoProductPrices.get(ticketNumber)) {
                    mco.setGdsId(mco.getGdsId() == null ? price.getSvcId() : mco.getGdsId() + "," + price.getSvcId());
                    Optional<Svc> segmentSvcOptional = answer.getPnr().getSvcs().getSvcs().stream().filter(svc -> price.getSvcId().equals(svc.getId())).findFirst();
                    if (!segmentSvcOptional.isPresent()) continue;
                    segmentSvcOptional.ifPresent(svcList::remove);
                    String segmentId = segmentSvcOptional.get().getSegmentId();
                    Pnr.Segments.Segment segment = (Pnr.Segments.Segment)segments.get(segmentId);
                    Segment s = new Segment();
                    s.setGdsId(segmentSvcOptional.get().getSegmentId());
                    this.copySegments(segment, s, price, mco, flight, st, (DictionaryReference<PassengerType>)mainProduct.getPassengerType());
                    Segment ticketSegment = AirProductHelper.getSegments((Collection)mainProduct.getSegmentTariffs()).stream().filter(seg -> seg.getGdsId().equals(s.getGdsId())).findFirst().orElse(null);
                    if (ticketSegment != null) {
                        s.setFareBasis(ticketSegment.getFareBasis());
                    }
                    if (mco.getMcoCategory() != MCOCategory.SEAT_RESERVATION) continue;
                    GdsTraveller gdsTraveller = gdsTravellers.get(mainProduct.getTravellerGdsId());
                    this.setSeatNumber(mco, gdsTraveller, ticketSegment, s, segmentList, segment);
                }
                OrderResponseParser.copyLostInfo(parameters.getFlight(), mco);
                if (mco.getFares().size() > 1) {
                    this.removeFaresWithZeroPrice(mco);
                }
                res.getProducts().add(mco);
            }
            if (!svcList.isEmpty()) {
                for (Svc svc2 : svcList) {
                    MiscUtil.Pair<Product, Product> mcoPair = this.buildMco(Collections.singletonList(svc2), res, gdsParameters, pult, answer, gdsName);
                    Product mco = (Product)mcoPair.getFirst();
                    Product mainProduct = (Product)mcoPair.getSecond();
                    Pnr.Segments.Segment segment = (Pnr.Segments.Segment)segments.get(svc2.getSegmentId());
                    Segment s = new Segment();
                    this.copySegments(segment, s, null, mco, flight, (SegmentTariff)mco.getSegmentTariffs().get(0), (DictionaryReference<PassengerType>)mainProduct.getPassengerType());
                    GdsTraveller gdsTraveller = gdsTravellers.get(mainProduct.getTravellerGdsId());
                    this.setSeatNumber(mco, gdsTraveller, null, s, segmentList, segment);
                    OrderResponseParser.copyLostInfo(parameters.getFlight(), mco);
                    mco.setMcoReservationRequestStatus(SirenaServerHelper.actionCode2MCOReservationRequestStatus(svc2.getStatus()));
                    if (mco.getMcoReservationRequestStatus() != MCOReservationRequestStatus.REJECTED) {
                        throw Xeption.forDeveloper((String)"Svc with no price in non-rejected status found - ", (Object[])new Object[]{svc2.getId()});
                    }
                    res.getProducts().add(mco);
                }
            }
        }
        return res;
    }

    private void setSeatNumber(Product mco, GdsTraveller gdsTraveller, Segment ticketSegment, Segment s, List<Pnr.Segments.Segment> segmentList, Pnr.Segments.Segment segment) {
        if (mco.getMcoCategory() == MCOCategory.SEAT_RESERVATION) {
            String seatNo = gdsTraveller.getSeatsReservationParameters().stream().filter(aircraftSeatReservationParameters -> aircraftSeatReservationParameters.getSegmentId().equals(String.valueOf(segmentList.indexOf(segment)))).map(AircraftSeatReservationParameters::getSeatNumber).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"AircraftSeatReservationParameters for segment not found", (Object[])new Object[0]));
            if (ticketSegment != null) {
                ticketSegment.setSeatNo(seatNo);
            }
            s.setSeatNo(seatNo);
        }
    }

    private MiscUtil.Pair<Product, Product> buildMco(List<Svc> svcList, Reservation res, GDSParameters gdsParameters, String pult, OrderAnswer answer, GdsName gdsName) {
        if (svcList.isEmpty()) {
            throw Xeption.forDeveloper((String)"svcList is empty", (Object[])new Object[0]);
        }
        Svc svc = svcList.get(0);
        String passengerId = svc.getPassengerId();
        Product mainProduct = GDSHelper.findProductByTravellerGdsId((Reservation)res, (String)passengerId, (ProductCategory)ProductCategory.AIR);
        if (mainProduct == null) {
            throw Xeption.forDeveloper((String)"can't find main product for svc_id - ", (Object[])new Object[]{svc.getId()});
        }
        Product mco = new Product();
        mco.setSalesOriginProvider(SalesOriginProvider.SIRENA);
        mco.setSalesOriginContent(SalesOriginContent.SIRENA);
        mco.setLuggageUnits(LuggageUnits.PIECE);
        double luggageWeight = 0.0;
        try {
            luggageWeight = Double.parseDouble(svc.getQtty());
        }
        catch (NumberFormatException e) {
            this.log.warn(String.format("Number of luggage was wrong for product %s in reservation %s", mco.getUid(), res.getUid()));
        }
        mco.setLuggageWeight(Double.valueOf(luggageWeight));
        mco.setReservation(mainProduct.getReservation());
        mco.setGdsCurrency(mainProduct.getGdsCurrency());
        mco.setTariffType(mainProduct.getTariffType());
        mco.setPassengerType(mainProduct.getPassengerType());
        mco.setTraveller(mainProduct.getTraveller());
        mco.setTravellerGdsId(mainProduct.getTravellerGdsId());
        mco.setProductCategory(ProductCategory.MCO);
        mco.setPcc(pult.substring(0, 4));
        mco.getRelatedProducts().add(mainProduct);
        mco.setMcoCancellationAllowed(true);
        mco.setErsp(answer.getPnr().getErsp());
        if (gdsParameters.getValidatingCarrier() != null) {
            mco.setCarrier(gdsParameters.getValidatingCarrier());
        }
        AncillaryFeeType ancillaryFeeType = SirenaServerHelper.convertAncillaryFeeTypeFromGds(svc.getServiceType());
        mco.setMcoCategory(GdsDictHelper.convertToMcoCategory((AncillaryFeeType)ancillaryFeeType));
        mco.setMcoReservationRequestStatus(SirenaServerHelper.getMCOReservationRequestStatusForRelatedProducts(svcList));
        AncillaryFeeDescription ancillaryFeeDescription = this.getAncillaryFeeDescription(svc, gdsName);
        if (ancillaryFeeDescription != null) {
            mco.setAncillaryFeeDescription((DictionaryReference)ancillaryFeeDescription.toReference());
            if (ancillaryFeeType == null) {
                mco.setMcoCategory(GdsDictHelper.convertToMcoCategory((AncillaryFeeType)ancillaryFeeDescription.getType()));
            }
        }
        SegmentTariff st = new SegmentTariff();
        mco.getSegmentTariffs().add(st);
        return new MiscUtil.Pair((Object)mco, (Object)mainProduct);
    }

    private void removeFaresWithZeroPrice(Product product) {
        product.getFares().removeIf(productFare -> productFare.getEquivalentFare().compareTo(BigDecimal.ZERO) == 0);
    }

    private void copySegments(Pnr.Segments.Segment from, Segment to, Pnr.Prices.Price price, Product product, Flight flight, SegmentTariff st, DictionaryReference<PassengerType> passengerType) throws Exception {
        String requestedBrands;
        String opeartingCompanyStr;
        to.setFlightDuration(Integer.valueOf(PF_FLIGHT_TIME.parsePeriod(from.getFlightTime()).toStandardMinutes().getMinutes()));
        to.setAirline(SirenaHelper.resolveNativeCode(Airline.class, (String)from.getCompany()));
        String string = opeartingCompanyStr = StringUtils.isNotBlank((String)from.getOperatingCompany()) ? from.getOperatingCompany() : from.getFranchiseCompany();
        if (!StringUtils.isBlank((String)opeartingCompanyStr)) {
            to.setCodeShareCarrier(SirenaHelper.resolveNativeCode(Airline.class, (String)opeartingCompanyStr));
            to.setCodeShare(!MiscUtil.equals((Object)to.getAirline(), (Object)to.getCodeShareCarrier()));
        } else {
            to.setCodeShareCarrier(to.getAirline());
        }
        to.setFlightNo(from.getFlight());
        to.setDepartureLocation(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)this.getLocationCode(from.getDeparture())));
        to.setDepartTerminal(from.getDeparture().getTerminal());
        to.setArriveLocation(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)this.getLocationCode(from.getArrival())));
        to.setArriveTerminal(from.getArrival().getTerminal());
        to.setStartDate(SirenaServerHelper.parseDate(from.getDeparture()));
        to.setEndDate(SirenaServerHelper.parseDate(from.getArrival()));
        to.setBoard(SirenaHelper.resolveNativeCode(Aircraft.class, (String)from.getAirplane()));
        to.setClassOfSvcCode(from.getClazz());
        to.setServiceClass(SirenaHelper.parseClassOfService((String)from.getBaseclass()));
        if (to.getServiceClass() == null) {
            to.setServiceClass(FlightHelper.findClassOfService((DictionaryReference)to.getAirline(), (DictionaryReference)to.getCodeShareCarrier(), (String)to.getClassOfSvcCode(), (boolean)DictHelper.isInternational((DictionaryReference)to.getDepartureLocation(), (DictionaryReference)to.getArriveLocation())));
        }
        if (price != null) {
            to.setFareBasis(price.getFare().getCode());
            to.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)price.getBaggage()));
            if (product.getCarrier() == null) {
                String validatingCompanyStr = price.getValidatingCompany();
                DictionaryReference carrierAirlineRef = SirenaHelper.resolveNativeCode(Airline.class, (String)validatingCompanyStr);
                product.setCarrier(carrierAirlineRef);
            }
            SirenaModelHelper.addFareAndTaxes(product, st, price);
        }
        if (to.getFareDetails() == null) {
            to.setFareDetails(new FareDetails());
        }
        if (!StringUtils.isBlank((String)(requestedBrands = SirenaCustomPropertiesHelper.getRequestedBrands((Flight)flight)))) {
            if (to.getFareDetails().getPricingParameters() == null) {
                to.getFareDetails().setPricingParameters(new FarePricingParameters());
            }
            to.getFareDetails().getPricingParameters().setBrandId(requestedBrands);
        }
        st.getSegments().add(to);
        flight.getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).map(segment -> FlightHelper.getFareInfo((FlightSegment)segment, (DictionaryReference)passengerType)).filter(Objects::nonNull).map(FareInfo::getFareDetails).filter(Objects::nonNull).map(FareDetails::getBrandName).filter(it -> !TextUtil.isBlank((String)it.getStringValue())).findFirst().ifPresent(it -> to.getFareDetails().getBrandName().setStringValue(it.getStringValue()));
    }

    private AncillaryFeeDescription getAncillaryFeeDescription(Svc svc, GdsName gdsName) {
        AncillaryFeeType ancillaryFeeType = SirenaServerHelper.convertAncillaryFeeTypeFromGds(svc.getServiceType());
        String ancillaryFeeKey = OrderResponseParser.buildAncillaryFeeKey(svc.getRfisc(), svc.getRfic());
        return GdsDictHelper.findAncillaryFeeDescriptionByServiceCode((AncillaryFeeType)ancillaryFeeType, (String)ancillaryFeeKey, (GdsName)gdsName);
    }

    public static String buildAncillaryFeeKey(String rfiscCode, String serviceType) {
        return String.join((CharSequence)"/", serviceType, rfiscCode);
    }
}

