/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class OrderResponseTimeLimitParser
extends BaseProcessor {
    private final DateFormat DF_FARE_EXP = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final DateFormat DF_TIMELIMIT = new SimpleDateFormat("dd.MM.yy HH:mm");
    private final DateFormat EMD_TIMELIMIT = new SimpleDateFormat("HH:mm dd.MM.yyyy");

    public OrderResponseTimeLimitParser() {
        this.DF_FARE_EXP.setTimeZone(SirenaServerHelper.getSirenaTimeZone());
        this.DF_TIMELIMIT.setTimeZone(SirenaServerHelper.getSirenaTimeZone());
        this.EMD_TIMELIMIT.setTimeZone(SirenaServerHelper.getSirenaTimeZone());
    }

    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        reservation.setPqTimeLimit(this.getTimelimit(answer));
    }

    private Date getTimelimit(OrderAnswer answer) throws Exception {
        Pnr.Svcs svcs;
        Date timeLimit = null;
        for (Pnr.Prices.Price price : answer.getPnr().getPrices().getPrices()) {
            if (StringUtils.isBlank((String)price.getFare().getFareExpdate())) continue;
            Date fareExpDate = this.DF_FARE_EXP.parse(price.getFare().getFareExpdate());
            if (timeLimit != null && !fareExpDate.before(timeLimit)) continue;
            timeLimit = fareExpDate;
        }
        Date pnrTimelimit = this.DF_TIMELIMIT.parse(answer.getPnr().getTimelimit());
        if (timeLimit == null || pnrTimelimit.before(timeLimit)) {
            timeLimit = pnrTimelimit;
        }
        if ((svcs = answer.getPnr().getSvcs()) != null) {
            for (Svc svc : svcs.getSvcs()) {
                if (StringUtils.isBlank((String)svc.getEmdTimeLimit())) continue;
                Date emdLimit = this.EMD_TIMELIMIT.parse(svc.getEmdTimeLimit());
                if (timeLimit != null && !emdLimit.before(timeLimit)) continue;
                timeLimit = emdLimit;
            }
        }
        return timeLimit;
    }
}

