/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class SaveStatisticalDataProcessor
extends BaseProcessor {
    private boolean optional;

    public void configure(Map<String, String> parameters) {
        super.configure(parameters);
        this.optional = Boolean.parseBoolean(parameters.get("optional"));
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        StatisticalData statData = (StatisticalData)ctx.getObject((Enum)IBusGdsContextKeys.STATISTICAL_DATA);
        if (statData == null) {
            if (this.optional) {
                return;
            }
            throw Xeption.forDeveloper((String)"Field STATISTICAL_DATA was not found in MessageContext, please check ibus route preceding this processor", (Object[])new Object[0]);
        }
        int numProductsSet = 0;
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product product = (Product)baseProduct;
            product.setStatisticalData(statData);
            ++numProductsSet;
        }
        if (numProductsSet != 1) {
            this.log.error("StatisticalData was set for != 1 products: " + numProductsSet);
        }
    }
}

