/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.createReservation;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.SetAgentDiscountQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class SetAgentDiscountRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(answer, flight));
    }

    private SirenaRequest<SetAgentDiscountQuery> buildRequest(OrderAnswer answer, Flight flight) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(answer, flight));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private SetAgentDiscountQuery buildQuery(OrderAnswer answer, Flight flight) {
        SetAgentDiscountQuery query = new SetAgentDiscountQuery();
        Regnum regnum = new Regnum();
        regnum.setValue(answer.getPnr().getRegnum());
        regnum.setVersion(answer.getPnr().getVersion());
        query.setRegnum(regnum);
        for (Pnr.Passengers.Passenger passenger : answer.getPnr().getPassengers().getPassengers()) {
            for (Pnr.Segments.Segment segment : answer.getPnr().getSegments().getSegments()) {
                SetAgentDiscountQuery.Unit unit = new SetAgentDiscountQuery.Unit();
                unit.setPassengerId(passenger.getId());
                unit.setSegmentId(segment.getId());
                SetAgentDiscountQuery.Unit.Fare fare = new SetAgentDiscountQuery.Unit.Fare();
                fare.setValue(flight.getTripartiteContractDetails().getPublicFareDiscount().getTicketDesignator());
                fare.setDiscount(flight.getTripartiteContractDetails().getPublicFareDiscount().getValue().toString());
                unit.setFare(fare);
                query.getUnits().add(unit);
            }
        }
        SetAgentDiscountQuery.RequestParams rp = new SetAgentDiscountQuery.RequestParams();
        rp.setTickSer("ETM");
        query.setRequestParams(rp);
        return query;
    }
}

