/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.db;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.BaseAirGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import java.util.HashMap;

public class SirenaCityFilterInterceptor
implements EntityInterceptor {
    public double getPriority() {
        return 0.0;
    }

    public void onSave(SessionCallback ss, EntityContainer<?> data) throws Exception {
        SirenaMtdFareSettings settings;
        EntityContainer<?> accountCtr;
        if (!AppConfiguration.get().isOnlineGdsEnabled()) {
            return;
        }
        if (data.getEntity() instanceof SirenaGdsAccount && ((SirenaGdsAccount)(accountCtr = data).getEntity()).isSearchCityFilterEnabled() && ((SirenaGdsAccount)accountCtr.getEntity()).getSearchCityFilterAirline() != null && SirenaCityFilterInterceptor.noCityFilter((DictionaryReference<Airline>)((SirenaGdsAccount)accountCtr.getEntity()).getSearchCityFilterAirline())) {
            SirenaCityFilterInterceptor.fillCityFilter(accountCtr);
        }
        if (data.getEntity() instanceof SirenaMtdFareSettings && (settings = (SirenaMtdFareSettings)data.getEntity()).isActive() && settings.getAirline() != null && settings.getGdsAccount() != null && SirenaCityFilterInterceptor.noCityFilter((DictionaryReference<Airline>)settings.getAirline())) {
            EntityContainer gdsAccountCtr = EntityStorage.get().resolve(settings.getGdsAccount());
            gdsAccountCtr = (EntityContainer)XCloneHelper.clone((XCloneable)gdsAccountCtr, (boolean)true);
            ((BaseAirGdsAccount)gdsAccountCtr.getEntity()).setSearchCityFilterEnabled(true);
            ((BaseAirGdsAccount)gdsAccountCtr.getEntity()).setSearchCityFilterAirline(settings.getAirline());
            SirenaCityFilterInterceptor.fillCityFilter((EntityContainer<? extends BaseAirGdsAccount>)gdsAccountCtr);
        }
    }

    private static boolean noCityFilter(DictionaryReference<Airline> airline) {
        return DictionaryCache.get().getAll(AirlineCityInfo.class).values().stream().noneMatch(aci -> airline.equals((Object)aci.getAirline()));
    }

    private static void fillCityFilter(EntityContainer<? extends BaseAirGdsAccount> gdsAccountCtr) {
        HashMap<String, EntityContainer<? extends BaseAirGdsAccount>> ctx = new HashMap<String, EntityContainer<? extends BaseAirGdsAccount>>();
        ctx.put(IBusMidofficeContextKeys.GDS_ACCOUNT.name(), gdsAccountCtr);
        IntegrationBusFacade.get().getRequestReplyAdapter("gds:sirena:city-filter:routing-grid-fill-account").processSync(ctx);
    }

    public void onDelete(SessionCallback ss, EntityContainer<?> data) throws Exception {
    }
}

