/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.db;

import com.gridnine.xtrip.common.gds.model.BaseMtdFareSettingsIndex;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettingsSsr;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.w3c.dom.Element;

public class SirenaMtdSsrMigrationHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        for (BaseMtdFareSettingsIndex idx : EntityStorage.get().search(BaseMtdFareSettingsIndex.class, new SearchQuery()).getData()) {
            SirenaMtdFareSettingsSsr ssr;
            if (idx.getGdsAccount() == null || !idx.getGdsAccount().getType().equals(SirenaGdsAccount.class)) continue;
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            SirenaMtdFareSettings settings = (SirenaMtdFareSettings)ctr.getEntity();
            if (!SirenaMtdSsrMigrationHandler.isAirline(settings, "SU")) {
                ssr = new SirenaMtdFareSettingsSsr();
                ssr.setCode("OTHS");
                ssr.setAllPassengers(true);
                ssr.setAllSegments(true);
                ssr.setText("${mtdNumber}");
                settings.getSsrs().add(ssr);
            }
            if (!SirenaMtdSsrMigrationHandler.isAirline(settings, "SU") && (settings.getPassengerStatuses().contains(PassengerStatus.VS_OVD) || settings.getPassengerStatuses().contains(PassengerStatus.VS_VV) || settings.getPassengerStatuses().contains(PassengerStatus.VS_OVD_KSK))) {
                ssr = new SirenaMtdFareSettingsSsr();
                ssr.setCode("OTHS");
                ssr.setAllPassengers(true);
                ssr.setAllSegments(true);
                ssr.setText("\u0422\u041a\u0421\u0422${passengerStatusRus}");
                settings.getSsrs().add(ssr);
            }
            if (SirenaMtdSsrMigrationHandler.isAirline(settings, "SU")) {
                ssr = new SirenaMtdFareSettingsSsr();
                ssr.setCode("OTHS");
                ssr.setAllPassengers(true);
                ssr.setAllSegments(true);
                ssr.setText("${passengerStatusEng}GA010");
                settings.getSsrs().add(ssr);
            }
            if (SirenaMtdSsrMigrationHandler.isAirline(settings, "UT") && (settings.getPassengerStatuses().contains(PassengerStatus.VS_OVD) || settings.getPassengerStatuses().contains(PassengerStatus.VS_VV) || settings.getPassengerStatuses().contains(PassengerStatus.VS_OVD_KSK))) {
                ssr = new SirenaMtdFareSettingsSsr();
                ssr.setCode("OTHS");
                ssr.setAllPassengers(false);
                ssr.setAllSegments(false);
                ssr.setText("\u0422\u041a\u0421\u0422 \u0414\u041e\u0413\u041e\u0412\u041e\u0420 63/15\u0420\u0411");
                settings.getSsrs().add(ssr);
                ssr = new SirenaMtdFareSettingsSsr();
                ssr.setCode("OTHS");
                ssr.setAllPassengers(false);
                ssr.setAllSegments(false);
                ssr.setText("\u041a\u0414\u0422\u0420 ${tripGoal}");
                settings.getSsrs().add(ssr);
            }
            ctr.getVersionInfo().setDataSource("VIP-32796");
            EntityStorage.get().save(ctr, true);
        }
    }

    private static boolean isAirline(SirenaMtdFareSettings settings, String code) {
        return code.equals(((Airline)DictionaryCache.get().resolveReference(settings.getAirline())).getCodeVariants().get(CodeSystem.IATA.name()));
    }
}

