/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.db;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.Actions;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.TripartiteDiscountDocument;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractIndex;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.rules.standard.Properties;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.tripartite.AviaTripartiteContractActions;
import com.gridnine.xtrip.common.rules.RuleRestriction;
import com.gridnine.xtrip.common.rules.RuleResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.RuleSettings;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SirenaTripartiteContractsRulesMigrationHandler
implements SetupUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(SirenaTripartiteContractsRulesMigrationHandler.class);

    public void execute(Element command) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TripartiteContractIndex.Property.contractType.name(), (Object)TripartiteContractType.AVIA));
        query.getPreferredProperties().add("uid");
        List data = EntityStorage.get().search(TripartiteContractIndex.class, query).getData();
        for (TripartiteContractIndex idx : data) {
            EntityContainer ctr = EntityStorage.get().resolve(idx.getSource());
            try {
                if (((TripartiteContract)ctr.getEntity()).getAviaVendorData().getAirlines().size() != 1) {
                    logger.error("contract {} skipped, as it has {} airlines", (Object)ctr.getUid(), (Object)((TripartiteContract)ctr.getEntity()).getAviaVendorData().getAirlines().size());
                    continue;
                }
                boolean modified = false;
                Optional<List> optRules = Optional.ofNullable(((TripartiteContract)ctr.getEntity()).getRuleSet()).map(RuleSet::getRules);
                if (optRules.isPresent()) {
                    boolean isForSu = "SU".equals(((Airline)DictionaryCache.get().resolveReference((DictionaryReference)CollectionUtil.single((Collection)((TripartiteContract)ctr.getEntity()).getAviaVendorData().getAirlines()))).getCodeVariants().get(CodeSystem.IATA.name()));
                    List rules = optRules.get();
                    for (RuleSettings rule : rules) {
                        if (!SirenaTripartiteContractsRulesMigrationHandler.isForSirena(rule)) continue;
                        if (!isForSu) {
                            DictionaryReference<PassengerType> substitutePassengerType;
                            String accountCode;
                            if (SirenaTripartiteContractsRulesMigrationHandler.getTourCode(rule, true) != null) {
                                modified = true;
                            }
                            if ((accountCode = SirenaTripartiteContractsRulesMigrationHandler.getAccountCode(rule, true)) != null) {
                                rule.getResults().add(SirenaTripartiteContractsRulesMigrationHandler.buildDiscountDocumentRuleResult("\u0422\u0421", accountCode));
                                rule.getResults().add(SirenaTripartiteContractsRulesMigrationHandler.buildTourcodeRuleResult(accountCode));
                                modified = true;
                            }
                            if ((substitutePassengerType = SirenaTripartiteContractsRulesMigrationHandler.getSubstitutePassengerType(rule)) == null) continue;
                            rule.getResults().add(SirenaTripartiteContractsRulesMigrationHandler.buildAccountCodeRuleResult(SirenaHelper.getNativeCode(substitutePassengerType)));
                            modified = true;
                            continue;
                        }
                        String tourCode = SirenaTripartiteContractsRulesMigrationHandler.getTourCode(rule, true);
                        if (tourCode == null) continue;
                        rule.getResults().add(SirenaTripartiteContractsRulesMigrationHandler.buildDiscountDocumentRuleResult("\u0422\u0421", tourCode));
                        rule.getResults().add(SirenaTripartiteContractsRulesMigrationHandler.buildRemarkRuleResult("OIN ".concat(tourCode)));
                        modified = true;
                    }
                }
                if (!modified) continue;
                ctr.getVersionInfo().setDataSource("SirenaTripartiteContractsRulesMigrationHandler");
                EntityStorage.get().save(ctr, true);
                logger.info("migrated rules in contract {}", (Object)ctr.getUid());
            }
            catch (Exception ex) {
                logger.error("failed migrating rules in contract {}", (Object)ctr.getUid(), (Object)ex);
            }
        }
    }

    private static RuleResult buildDiscountDocumentRuleResult(String code, String number) {
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)Actions.TRIPARTITE_DISCOUNT_DOCUMENT);
        TripartiteDiscountDocument doc = new TripartiteDiscountDocument();
        doc.setCode(code);
        doc.setNumber(number);
        rr.setValue((Object)doc);
        return rr;
    }

    private static RuleResult buildRemarkRuleResult(String value) {
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)AviaTripartiteContractActions.TRIPARTITE_CONTRACT_REMARK);
        rr.setValue((Object)value);
        return rr;
    }

    private static String getTourCode(RuleSettings rule, boolean remove) {
        Iterator iter = rule.getResults().iterator();
        while (iter.hasNext()) {
            RuleResult rr = (RuleResult)iter.next();
            if (rr.getAction() != AviaTripartiteContractActions.AVIA_TOUR_CODE) continue;
            List codes = RulesHelper.toStringCollection((Object)rr.getValue());
            if (remove) {
                iter.remove();
            }
            return (String)CollectionUtil.single((Collection)codes);
        }
        return null;
    }

    private static RuleResult buildTourcodeRuleResult(String code) {
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_TOUR_CODE);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(code);
        rr.setValue(codes);
        return rr;
    }

    private static String getAccountCode(RuleSettings rule, boolean remove) {
        Iterator iter = rule.getResults().iterator();
        while (iter.hasNext()) {
            RuleResult rr = (RuleResult)iter.next();
            if (rr.getAction() != AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE) continue;
            List codes = RulesHelper.toStringCollection((Object)rr.getValue());
            if (remove) {
                iter.remove();
            }
            return (String)CollectionUtil.single((Collection)codes);
        }
        return null;
    }

    private static RuleResult buildAccountCodeRuleResult(String code) {
        RuleResult rr = new RuleResult();
        rr.setAction((RuleAction)AviaTripartiteContractActions.AVIA_ACCOUNTING_CODE);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add(code);
        rr.setValue(codes);
        return rr;
    }

    private static DictionaryReference<PassengerType> getSubstitutePassengerType(RuleSettings rule) {
        for (RuleResult rr : rule.getResults()) {
            if (rr.getAction() != AviaTripartiteContractActions.SUBSTITUTE_PASSENGER_TYPE) continue;
            return (DictionaryReference)rr.getValue();
        }
        return null;
    }

    private static boolean isForSirena(RuleSettings rule) {
        return rule.getRestrictions().stream().anyMatch(SirenaTripartiteContractsRulesMigrationHandler::isForSirena);
    }

    private static boolean isForSirena(RuleRestriction rr) {
        List value;
        if (rr.getProperty() == Properties.GDS_NAME && (value = (List)rr.getValue()).size() == 1 && value.get(0) == GdsName.SIRENA) {
            return true;
        }
        if (rr.getProperty() == com.gridnine.xtrip.common.gds.rules.Properties.GDS_ACCOUNT) {
            value = (List)rr.getValue();
            Set gdsNames = value.stream().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(BaseGdsAccount::getGds).collect(Collectors.toSet());
            if (gdsNames.size() == 1 && gdsNames.iterator().next() == GdsName.SIRENA) {
                return true;
            }
        }
        return false;
    }
}

