/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.getFareRules;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.model.FareRuleParagraph;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FareRulesParagraph16Parser {
    private final Money DIFFERENT_PENALTIES = new Money("DIFFERENT_PENALTIES");
    private final Logger log = LoggerFactory.getLogger(FareRulesParagraph16Parser.class);
    private static final FareRulesParagraph16Parser INSTANCE = new FareRulesParagraph16Parser();
    private static final String AS_AFTER_DEPARTURE = "afterDeparture";
    private static final String AS_SOME_TIME_BEFORE_DEPARTURE = "someTimeBeforeDeparture";
    private static final String AS_BEFORE_DEPARTURE = "beforeDeparture";
    private static final String AS_PENALTY_SUM = "penaltySum";
    private static final String AS_CONDITION = "condition";
    private static final String AS_CATEGORY = "category";
    private static final int FLAGS = 106;
    private static final String PARAGRAPH_METABLOCKS_DELIMITER = FareRulesParagraph16Parser.bold("\u0418\u043d\u0430\u0447\u0435");
    private static final String PARAGRAPH_BLOCKS_DELIMITER = FareRulesParagraph16Parser.bold("\u0438\u043b\u0438");
    private static final String ANY = ".*?";
    private static final String SPACE = "[ \n]{1,100}";
    private static final String DOT = "\\.";
    private static final String REFUND_ALLOWED = FareRulesParagraph16Parser.spaceBetween("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f");
    private static final String FORCED = "\u0432\u044b\u043d\u0443\u0436\u0434\u0435\u043d\u043d\u044b\u0439";
    private static final String REFUND_FORBIDDEN = FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.or("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0430\u0435\u0442\u0441\u044f", "\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d"));
    private static final String SOME_TIME = "[0-9]{1,2} [\u0410-\u042f]{3,6}";
    private static final String SOME_TIME_EXCEPT_MINUTES = "[0-9]{1,2} " + FareRulesParagraph16Parser.exceptBeginning("\u041c\u0418\u041d", "[\u0410-\u042f]{3,6}");
    private static final String BEFORE_DEPARTURE = FareRulesParagraph16Parser.grab("beforeDeparture", FareRulesParagraph16Parser.or(FareRulesParagraph16Parser.exceptBehind("\u043c\u0435\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 " + FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.italics("[0-9]{1,2} [\u0410-\u042f]{3,6}", true)) + " ", FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.or("\u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f", "\u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430"))), FareRulesParagraph16Parser.spaceBetween("\u0411\u041e\u041b\u0415\u0415 \u0427\u0415\u041c \u0417\u0410 [0-9]{1,2} [\u0410-\u042f]{3,6} \u0414\u041e \u0412\u0420\u0415\u041c\u0415\u041d\u0418 \u0412\u042b\u041b\u0415\u0422\u0410"), FareRulesParagraph16Parser.spaceBetween("\u0417\u0410 " + FareRulesParagraph16Parser.italics("[0-9]{1,2} [\u0410-\u042f]{3,6}") + " \u0418 \u0411\u041e\u041b\u0415\u0415 \u0414\u041e \u041e\u0422\u041f\u0420\u0410\u0412\u041b\u0415\u041d\u0418\u042f"), FareRulesParagraph16Parser.spaceBetween("\u0417\u0410 \u0418\u0421\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415\u041c \u0421\u041b\u0423\u0427\u0410\u0415\u0412 \u041d\u0415\u042f\u0412\u041a\u0418 \u041d\u0410 \u0420\u0415\u0419\u0421 \\(NO-SHOW\\)")));
    private static final String SOME_TIME_BEFORE_DEPARTURE = FareRulesParagraph16Parser.grab("someTimeBeforeDeparture", FareRulesParagraph16Parser.spaceBetween("\u043c\u0435\u043d\u0435\u0435 \u0447\u0435\u043c \u0437\u0430 " + FareRulesParagraph16Parser.italics(SOME_TIME_EXCEPT_MINUTES, true) + " " + FareRulesParagraph16Parser.or("\u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430", "\u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f")));
    private static final String AFTER_DEPARTURE = FareRulesParagraph16Parser.grab("afterDeparture", FareRulesParagraph16Parser.or(FareRulesParagraph16Parser.spaceBetween("\u043f\u043e\u0441\u043b\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f"), FareRulesParagraph16Parser.spaceBetween("\u041f\u041e\u0421\u041b\u0415 \u0412\u042b\u041b\u0415\u0422\u0410"), FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 \u041d\u0415\u042f\u0412\u041a\u0418 \u041d\u0410 \u0420\u0415\u0419\u0421")));
    private static final String COLLECT = FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.or("\u0432\u0437\u0438\u043c\u0430\u0435\u0442\u0441\u044f", "\u0443\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f") + FareRulesParagraph16Parser.or(" \u0441\u0431\u043e\u0440" + FareRulesParagraph16Parser.opt(" \u0437\u0430 [\u0430-\u044f]+"), " \u043f\u043b\u0430\u0442\u0430") + FareRulesParagraph16Parser.opt(FareRulesParagraph16Parser.or(" \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435", " -")));
    private static final String PENALTY_SUM = FareRulesParagraph16Parser.grab("penaltySum", "[0-9.]+");
    private static final String CURRENCY = "\u0440\u0443\u0431";
    private static final String PENALTY = FareRulesParagraph16Parser.italics(PENALTY_SUM + FareRulesParagraph16Parser.opt("[ \n]{1,100}") + "\u0440\u0443\u0431", true);
    private static final String EXCHANGE_ALLOWED = FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.italics("\u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u0435") + " \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0440\u0430\u0437\u0440\u0435\u0448\u0430\u0435\u0442\u0441\u044f");
    private static final String EXCHANGE_FORBIDDEN = FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.italics("\u0434\u043e\u0431\u0440\u043e\u0432\u043e\u043b\u044c\u043d\u043e\u0435") + " \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043a\u0438 \u0437\u0430\u043f\u0440\u0435\u0449\u0430\u0435\u0442\u0441\u044f");
    private static final String EXCHANGE_CONDITION = FareRulesParagraph16Parser.grab("condition", FareRulesParagraph16Parser.or(FareRulesParagraph16Parser.spaceBetween("\u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u0431\u0438\u043b\u0435\u0442\u0430/\u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0439 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0431\u0438\u043b\u0435\u0442\u0430"), FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 \u041e\u0422\u041a\u0410\u0417\u0410 \u041e\u0422 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u041a\u0418 \\(NO SHOW\\)"), FareRulesParagraph16Parser.spaceBetween("\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u042b \u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u0414\u0410\u0422\u042b\\\\\u0412\u0420\u0415\u041c\u0415\u041d\u0418 \u0412\u042b\u041b\u0415\u0422\u0410\\\\\u041c\u0410\u0420\u0428\u0420\u0423\u0422\u0410\\\\\u041a\u041b\u0410\u0421\u0421\u0410 \u041e\u0411\u0421\u041b\u0423\u0416\u0418\u0412\u0410\u041d\u0418\u042f"), FareRulesParagraph16Parser.spaceBetween("\u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430/\u043f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f"), FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 (\u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u041c\u0410\u0420\u0428\u0420\u0423\u0422\u0410/)?\u041f\u0415\u0420\u0415\u041e\u0424\u041e\u0420\u041c\u041b\u0415\u041d\u0418\u042f \u041d\u0410 \u0411\u041e\u041b\u0415\u0415 \u0420\u0410\u041d\u041d\u042e\u042e\\(\u0415\u0415\\) \u0414\u0410\u0422\u0423\\(\u0412\u0420\u0415\u041c\u042f\\)/\u041f\u0415\u0420\u0415\u041e\u0424\u041e\u0420\u041c\u041b\u0415\u041d\u0418\u042f \u041d\u0410 \u0411\u041e\u041b\u0415\u0415 \u041f\u041e\u0417\u0414\u041d\u042e\u042e\\(\u0415\u0415\\) \u0414\u0410\u0422\u0423\\(\u0412\u0420\u0415\u041c\u042f\\)")));
    private static final String EXCHANGE_IGNORED_CONDITION = FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 \u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u0424\u0418\u041e");
    private static final String REFUND_CONDITION = FareRulesParagraph16Parser.grab("condition", FareRulesParagraph16Parser.or(FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 \u0410\u041d\u041d\u0423\u041b\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u042f \u0417\u0410\u041a\u0410\u0417\u0410/\u041e\u0422\u041a\u0410\u0417\u0410 \u041e\u0422 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u041a\u0418 \\(NO SHOW\\)/\u0412\u041e\u0417\u0412\u0420\u0410\u0422\u0410 \u0411\u0418\u041b\u0415\u0422\u0410"), FareRulesParagraph16Parser.spaceBetween("\u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u0437\u0430/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0431\u0438\u043b\u0435\u0442\u0430"), FareRulesParagraph16Parser.spaceBetween("\u041f\u041e \u041f\u041e\u041b\u041d\u041e\u0421\u0422\u042c\u042e \u041d\u0415\u0418\u0421\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u041d\u041d\u041e\u041c\u0423 \u0411\u0418\u041b\u0415\u0422\u0423"), FareRulesParagraph16Parser.spaceBetween("\u0412 \u0421\u041b\u0423\u0427\u0410\u0415 \u041e\u0422\u041a\u0410\u0417\u0410 \u041e\u0422 \u041f\u0415\u0420\u0415\u0412\u041e\u0417\u041a\u0418 \\(NO SHOW\\)")));
    private static final String NO_PENALTY = FareRulesParagraph16Parser.spaceBetween(FareRulesParagraph16Parser.or("\u0441\u0431\u043e\u0440 \u043d\u0435 \u0432\u0437\u0438\u043c\u0430\u0435\u0442\u0441\u044f", "\u0411\u0415\u0417 \u041f\u0420\u0418\u041c\u0415\u041d\u0415\u041d\u0418\u042f \u0428\u0422\u0420\u0410\u0424\u041d\u042b\u0425 \u0421\u0410\u041d\u041a\u0426\u0418\u0419"));
    private static final Pattern NO_SHOW = Pattern.compile(FareRulesParagraph16Parser.spaceBetween("NO SHOW"));
    private static final String PARAGRAPH_CATEGORY_DELIMITER = FareRulesParagraph16Parser.bold(".*\u0435\u0441\u043b\u0438");
    private static final Pattern PATTERN_CATEGORY = FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.spaceBetween("(\u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f|\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f)") + "[ \n]{1,100}" + FareRulesParagraph16Parser.singleQuotes(FareRulesParagraph16Parser.italics(FareRulesParagraph16Parser.grab("category", "(\\S{3})"))));
    private static final List<Pattern> PATTERNS_FREE_REFUND_ALLOWED = new ArrayList<Pattern>();
    private static final List<Pattern> PATTERNS_REFUND_ALLOWED;
    private static final List<Pattern> PATTERNS_REFUND_WITH_PENALTY_ALLOWED;
    private static final List<Pattern> PATTERNS_REFUND_FORBIDDEN;
    private static final List<Pattern> PATTERNS_FREE_EXCHANGE_ALLOWED;
    private static final List<Pattern> PATTERNS_EXCHANGE_ALLOWED;
    private static final List<Pattern> PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED;
    private static final List<Pattern> PATTERNS_EXCHANGE_FORBIDDEN;

    private FareRulesParagraph16Parser() {
    }

    public static FareRulesParagraph16Parser get() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PenaltiesInfo> getPenaltiesInfo(FareRuleParagraph paragraph) throws Exception {
        if (!paragraph.getNumber().equals("16")) {
            throw Xeption.forDeveloper((String)"Not paragraph 16", (Object[])new Object[0]);
        }
        List metablocks = Arrays.stream(paragraph.getContent().split(PARAGRAPH_METABLOCKS_DELIMITER)).flatMap(m -> Arrays.stream(m.split(PARAGRAPH_CATEGORY_DELIMITER))).collect(Collectors.toList());
        if (metablocks.size() == 0) {
            this.log.error("No metablocks found after exclusion");
        }
        if (metablocks.size() == 1) {
            return this.parseMetablock((String)metablocks.get(0));
        }
        ExecutorServiceFacade service = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("fare-rules-paragraph-16-parser", metablocks.size());
        try {
            ArrayList<Callable<Map>> tasks = new ArrayList<Callable<Map>>();
            for (String metablock : metablocks) {
                tasks.add(() -> this.parseMetablock(metablock));
            }
            HashMap resultMap = new HashMap();
            List futures = service.invokeAll(tasks);
            for (Future future : futures) {
                resultMap.putAll((Map)future.get());
            }
            HashMap hashMap = resultMap;
            return hashMap;
        }
        finally {
            service.dispose();
        }
    }

    private Map<String, PenaltiesInfo> parseMetablock(String metablock) throws Exception {
        List<String> categories = this.getCategoriesForCategoryBlock(metablock);
        PenaltiesInfo penaltiesInfo = this.getPenaltiesInfoForCategoryBlock(metablock);
        if (categories.size() < 2) {
            return Collections.singletonMap(CollectionUtil.head(categories), penaltiesInfo);
        }
        HashMap<String, PenaltiesInfo> result = new HashMap<String, PenaltiesInfo>();
        for (int i = 0; i < categories.size(); ++i) {
            if (i > 0) {
                penaltiesInfo = (PenaltiesInfo)XCloneHelper.clone((XCloneable)penaltiesInfo, (boolean)true);
            }
            result.put(categories.get(i), penaltiesInfo);
        }
        return result;
    }

    private List<String> getCategoriesForCategoryBlock(String categoryBlock) {
        ArrayList<String> categories = new ArrayList<String>();
        Matcher matcher = PATTERN_CATEGORY.matcher(categoryBlock);
        while (matcher.find()) {
            categories.add(matcher.group(AS_CATEGORY));
        }
        return categories;
    }

    private PenaltiesInfo getPenaltiesInfoForCategoryBlock(String categoryBlock) {
        String[] blocks;
        PenaltiesInfo result = new PenaltiesInfo();
        for (String block : blocks = categoryBlock.split(PARAGRAPH_BLOCKS_DELIMITER)) {
            Matcher matcher;
            for (Pattern pattern : PATTERNS_FREE_REFUND_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillFreeRefundInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_REFUND_WITH_PENALTY_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillRefundWithPenaltyInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_REFUND_FORBIDDEN) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillRefundForbiddenInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_REFUND_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillRefundInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_FREE_EXCHANGE_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillFreeExchangeInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillExchangeWithPenaltyInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_EXCHANGE_FORBIDDEN) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillExchangeForbiddenInfo(result, matcher);
            }
            for (Pattern pattern : PATTERNS_EXCHANGE_ALLOWED) {
                matcher = pattern.matcher(block);
                if (!matcher.matches()) continue;
                this.fillExchangeInfo(result, matcher);
            }
        }
        if (this.DIFFERENT_PENALTIES.equals((Object)result.getRefundBeforeDeparture())) {
            result.setRefundBeforeDeparture(null);
        }
        if (this.DIFFERENT_PENALTIES.equals((Object)result.getRefundAfterDeparture())) {
            result.setRefundAfterDeparture(null);
        }
        if (this.DIFFERENT_PENALTIES.equals((Object)result.getExchangeBeforeDeparture())) {
            result.setExchangeBeforeDeparture(null);
        }
        if (this.DIFFERENT_PENALTIES.equals((Object)result.getExchangeAfterDeparture())) {
            result.setExchangeAfterDeparture(null);
        }
        return result;
    }

    private void fillRefundInfo(PenaltiesInfo result, Matcher matcher) {
        boolean afterDeparture;
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean bl = afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(null);
            }
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
            }
        } else {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
            }
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
            }
        }
    }

    private void fillExchangeInfo(PenaltiesInfo result, Matcher matcher) {
        boolean afterDeparture;
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean bl = afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(null);
            }
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
            }
        } else {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
            }
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
            }
        }
    }

    private void fillFreeRefundInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        Money zeroPenalty = MoneyHelper.buildMoney((BigDecimal)BigDecimal.ZERO, (String)"RUB");
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(zeroPenalty);
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(zeroPenalty);
            }
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(zeroPenalty);
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(zeroPenalty);
            }
        } else {
            if (result.getRefundableBeforeDeparture() == null) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(zeroPenalty);
            }
            if (result.getRefundableAfterDeparture() == null) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(zeroPenalty);
            }
        }
    }

    private void fillRefundWithPenaltyInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        String condition = matcher.pattern().pattern().contains(AS_CONDITION) ? matcher.group(AS_CONDITION) : null;
        boolean onlyNoShow = false;
        if (condition != null) {
            boolean bl = onlyNoShow = NO_SHOW.matcher(condition).find() && condition.split("/").length == 1;
        }
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() != Boolean.FALSE) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundBeforeDeparture(), true));
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() != Boolean.FALSE) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundBeforeDeparture(), false));
            }
            if (result.getRefundableAfterDeparture() != Boolean.FALSE) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundAfterDeparture(), true));
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getRefundableAfterDeparture() != Boolean.FALSE) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundAfterDeparture(), true));
            }
        } else {
            if (result.getRefundableBeforeDeparture() != Boolean.FALSE && !onlyNoShow) {
                result.setRefundableBeforeDeparture(Boolean.TRUE);
                result.setRefundBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundBeforeDeparture(), true));
            }
            if (result.getRefundableAfterDeparture() != Boolean.FALSE) {
                result.setRefundableAfterDeparture(Boolean.TRUE);
                result.setRefundAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getRefundAfterDeparture(), true));
            }
        }
    }

    private void fillRefundForbiddenInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        String condition = matcher.pattern().pattern().contains(AS_CONDITION) ? matcher.group(AS_CONDITION) : null;
        boolean onlyNoShow = false;
        if (condition != null) {
            boolean bl = onlyNoShow = NO_SHOW.matcher(condition).find() && condition.split("/").length == 1;
        }
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            result.setRefundableBeforeDeparture(Boolean.FALSE);
            result.setRefundBeforeDeparture(null);
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getRefundableBeforeDeparture() != Boolean.TRUE) {
                result.setRefundableBeforeDeparture(Boolean.FALSE);
            }
            result.setRefundBeforeDeparture(null);
            result.setRefundableAfterDeparture(Boolean.FALSE);
            result.setRefundAfterDeparture(null);
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            result.setRefundableAfterDeparture(Boolean.FALSE);
            result.setRefundAfterDeparture(null);
        } else {
            if (!onlyNoShow) {
                result.setRefundableBeforeDeparture(Boolean.FALSE);
                result.setRefundBeforeDeparture(null);
            }
            result.setRefundableAfterDeparture(Boolean.FALSE);
            result.setRefundAfterDeparture(null);
        }
    }

    private void fillFreeExchangeInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        Money zeroPenalty = MoneyHelper.buildMoney((BigDecimal)BigDecimal.ZERO, (String)"RUB");
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(zeroPenalty);
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(zeroPenalty);
            }
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(zeroPenalty);
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(zeroPenalty);
            }
        } else {
            if (result.getExchangableBeforeDeparture() == null) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(zeroPenalty);
            }
            if (result.getExchangableAfterDeparture() == null) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(zeroPenalty);
            }
        }
    }

    private void fillExchangeWithPenaltyInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        String condition = matcher.pattern().pattern().contains(AS_CONDITION) ? matcher.group(AS_CONDITION) : null;
        boolean onlyNoShow = false;
        if (condition != null) {
            boolean bl = onlyNoShow = NO_SHOW.matcher(condition).find() && condition.split("/").length == 1;
        }
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() != Boolean.FALSE) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeBeforeDeparture(), true));
            }
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() != Boolean.FALSE) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeBeforeDeparture(), false));
            }
            if (result.getExchangableAfterDeparture() != Boolean.FALSE) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeAfterDeparture(), true));
            }
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            if (result.getExchangableAfterDeparture() != Boolean.FALSE) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeAfterDeparture(), true));
            }
        } else {
            if (result.getExchangableBeforeDeparture() != Boolean.FALSE && !onlyNoShow) {
                result.setExchangableBeforeDeparture(Boolean.TRUE);
                result.setExchangeBeforeDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeBeforeDeparture(), true));
            }
            if (result.getExchangableAfterDeparture() != Boolean.FALSE) {
                result.setExchangableAfterDeparture(Boolean.TRUE);
                result.setExchangeAfterDeparture(this.compareAndGetPenaltySum(matcher, result.getExchangeAfterDeparture(), true));
            }
        }
    }

    private void fillExchangeForbiddenInfo(PenaltiesInfo result, Matcher matcher) {
        boolean beforeDeparture = matcher.pattern().pattern().contains(AS_BEFORE_DEPARTURE) && matcher.group(AS_BEFORE_DEPARTURE) != null;
        boolean someTimeBeforeDeparture = matcher.pattern().pattern().contains(AS_SOME_TIME_BEFORE_DEPARTURE) && matcher.group(AS_SOME_TIME_BEFORE_DEPARTURE) != null;
        boolean afterDeparture = matcher.pattern().pattern().contains(AS_AFTER_DEPARTURE) && matcher.group(AS_AFTER_DEPARTURE) != null;
        String condition = matcher.pattern().pattern().contains(AS_CONDITION) ? matcher.group(AS_CONDITION) : null;
        boolean onlyNoShow = false;
        if (condition != null) {
            boolean bl = onlyNoShow = NO_SHOW.matcher(condition).find() && condition.split("/").length == 1;
        }
        if (beforeDeparture && !someTimeBeforeDeparture && !afterDeparture) {
            result.setExchangableBeforeDeparture(Boolean.FALSE);
            result.setExchangeBeforeDeparture(null);
        } else if (!beforeDeparture && someTimeBeforeDeparture && !afterDeparture) {
            if (result.getExchangableBeforeDeparture() != Boolean.TRUE) {
                result.setExchangableBeforeDeparture(Boolean.FALSE);
            }
            result.setExchangeBeforeDeparture(null);
            result.setExchangableAfterDeparture(Boolean.FALSE);
            result.setExchangeAfterDeparture(null);
        } else if (!beforeDeparture && !someTimeBeforeDeparture && afterDeparture) {
            result.setExchangableAfterDeparture(Boolean.FALSE);
            result.setExchangeAfterDeparture(null);
        } else {
            if (!onlyNoShow) {
                result.setExchangableBeforeDeparture(Boolean.FALSE);
                result.setExchangeBeforeDeparture(null);
            }
            result.setExchangableAfterDeparture(Boolean.FALSE);
            result.setExchangeAfterDeparture(null);
        }
    }

    private Money compareAndGetPenaltySum(Matcher matcher, Money currentPenalty, boolean differentPenaltiesAllowed) {
        BigDecimal penaltySumValue;
        if (this.DIFFERENT_PENALTIES.equals((Object)currentPenalty)) {
            return this.DIFFERENT_PENALTIES;
        }
        BigDecimal newPenaltySumValue = new BigDecimal(matcher.group(AS_PENALTY_SUM));
        if (currentPenalty == null) {
            penaltySumValue = newPenaltySumValue;
        } else if (differentPenaltiesAllowed || MiscUtil.equals((Object)currentPenalty.getValue(), (Object)newPenaltySumValue)) {
            penaltySumValue = newPenaltySumValue.compareTo(currentPenalty.getValue()) > 0 ? newPenaltySumValue : currentPenalty.getValue();
        } else {
            return this.DIFFERENT_PENALTIES;
        }
        return MoneyHelper.buildMoney((BigDecimal)penaltySumValue, (String)"RUB");
    }

    private static Pattern pattern(String patternStr) {
        return Pattern.compile(patternStr, 106);
    }

    private static String opt(String str) {
        return String.format("(%s)?", str);
    }

    private static String or(String ... patternStrs) {
        if (patternStrs.length < 2) {
            throw Xeption.forDeveloper((String)"too few arguments", (Object[])new Object[0]);
        }
        return String.format("(%s)", String.join((CharSequence)"|", patternStrs));
    }

    private static String anyExcept(String exceptStr) {
        return String.format("((?!%s).)*?", exceptStr);
    }

    private static String exceptBehind(String behind, String patternStr) {
        return String.format("(?<!%s)%s", behind, patternStr);
    }

    private static String exceptBeginning(String beginning, String patternStr) {
        return String.format("(?!%s)%s", beginning, patternStr);
    }

    private static String grab(String name, String patternStr) {
        return String.format("(?<%s>%s)", name, patternStr);
    }

    private static String spaceBetween(String patternStr) {
        return String.join((CharSequence)SPACE, patternStr.split(" "));
    }

    private static String italics(String patternStr, boolean optional) {
        if (optional) {
            return FareRulesParagraph16Parser.opt("<i>") + patternStr + FareRulesParagraph16Parser.opt("</i>");
        }
        return "<i>" + patternStr + "</i>";
    }

    private static String italics(String patternStr) {
        return FareRulesParagraph16Parser.italics(patternStr, false);
    }

    private static String bold(String patternStr) {
        return "<b>" + patternStr + "</b>";
    }

    private static String singleQuotes(String patternStr) {
        return String.format("'%s'", patternStr);
    }

    static {
        PATTERNS_FREE_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(REFUND_CONDITION + SPACE) + BEFORE_DEPARTURE + FareRulesParagraph16Parser.opt(ANY + SOME_TIME_BEFORE_DEPARTURE) + FareRulesParagraph16Parser.anyExcept(COLLECT) + NO_PENALTY + ANY));
        PATTERNS_FREE_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(REFUND_CONDITION + SPACE) + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + ANY + NO_PENALTY + ANY));
        PATTERNS_FREE_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(BEFORE_DEPARTURE, SOME_TIME_BEFORE_DEPARTURE, AFTER_DEPARTURE)) + NO_PENALTY + ANY));
        PATTERNS_REFUND_ALLOWED = new ArrayList<Pattern>();
        PATTERNS_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(REFUND_CONDITION + SPACE) + BEFORE_DEPARTURE + FareRulesParagraph16Parser.opt(ANY + SOME_TIME_BEFORE_DEPARTURE) + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(REFUND_CONDITION + SPACE) + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_REFUND_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + DOT + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED = new ArrayList<Pattern>();
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + REFUND_CONDITION + SPACE + BEFORE_DEPARTURE + ANY + SOME_TIME_BEFORE_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + SPACE + REFUND_CONDITION + SPACE + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + FareRulesParagraph16Parser.opt(SPACE) + REFUND_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + REFUND_CONDITION) + SPACE + BEFORE_DEPARTURE + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(SOME_TIME_BEFORE_DEPARTURE, AFTER_DEPARTURE)) + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + REFUND_CONDITION) + SPACE + SOME_TIME_BEFORE_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_REFUND_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SPACE + REFUND_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + REFUND_CONDITION) + SPACE + AFTER_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_REFUND_FORBIDDEN = new ArrayList<Pattern>();
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + REFUND_FORBIDDEN + SPACE + REFUND_CONDITION + SPACE + BEFORE_DEPARTURE + ANY + SOME_TIME_BEFORE_DEPARTURE + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + REFUND_FORBIDDEN + FareRulesParagraph16Parser.opt(SPACE + REFUND_CONDITION) + SPACE + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + SOME_TIME_BEFORE_DEPARTURE + SPACE + REFUND_FORBIDDEN + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + AFTER_DEPARTURE + SPACE + REFUND_FORBIDDEN + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + REFUND_FORBIDDEN + SPACE + SOME_TIME_BEFORE_DEPARTURE + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + REFUND_FORBIDDEN + SPACE + AFTER_DEPARTURE + ANY));
        PATTERNS_REFUND_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(FareRulesParagraph16Parser.anyExcept(FORCED) + REFUND_FORBIDDEN + DOT + ANY));
        PATTERNS_FREE_EXCHANGE_ALLOWED = new ArrayList<Pattern>();
        PATTERNS_FREE_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + EXCHANGE_CONDITION) + ANY + BEFORE_DEPARTURE + FareRulesParagraph16Parser.opt(ANY + SOME_TIME_BEFORE_DEPARTURE) + ANY + NO_PENALTY + ANY));
        PATTERNS_FREE_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + EXCHANGE_CONDITION) + ANY + BEFORE_DEPARTURE + FareRulesParagraph16Parser.opt(ANY + AFTER_DEPARTURE) + ANY + NO_PENALTY + ANY));
        PATTERNS_FREE_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + EXCHANGE_CONDITION) + ANY + SOME_TIME_BEFORE_DEPARTURE + ANY + NO_PENALTY + ANY));
        PATTERNS_FREE_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.opt(SPACE + EXCHANGE_CONDITION) + ANY + AFTER_DEPARTURE + ANY + NO_PENALTY + ANY));
        PATTERNS_FREE_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(BEFORE_DEPARTURE, SOME_TIME_BEFORE_DEPARTURE, AFTER_DEPARTURE)) + NO_PENALTY + ANY));
        PATTERNS_EXCHANGE_ALLOWED = new ArrayList<Pattern>();
        PATTERNS_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + SPACE + EXCHANGE_CONDITION + SPACE + BEFORE_DEPARTURE + FareRulesParagraph16Parser.opt(ANY + SOME_TIME_BEFORE_DEPARTURE) + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + SPACE + EXCHANGE_CONDITION + SPACE + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_EXCHANGE_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + DOT + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(NO_PENALTY, PENALTY))));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED = new ArrayList<Pattern>();
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + FareRulesParagraph16Parser.anyExcept(EXCHANGE_IGNORED_CONDITION) + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + BEFORE_DEPARTURE + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(SOME_TIME_BEFORE_DEPARTURE, AFTER_DEPARTURE)) + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + ANY + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + SOME_TIME_BEFORE_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + ANY + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + AFTER_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + BEFORE_DEPARTURE + ANY + SOME_TIME_BEFORE_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + SPACE + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + BEFORE_DEPARTURE + ANY + AFTER_DEPARTURE + ANY + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_WITH_PENALTY_ALLOWED.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_ALLOWED + ANY + EXCHANGE_CONDITION + FareRulesParagraph16Parser.anyExcept(FareRulesParagraph16Parser.or(BEFORE_DEPARTURE, SOME_TIME_BEFORE_DEPARTURE, AFTER_DEPARTURE)) + COLLECT + SPACE + PENALTY + ANY));
        PATTERNS_EXCHANGE_FORBIDDEN = new ArrayList<Pattern>();
        PATTERNS_EXCHANGE_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_FORBIDDEN + ANY + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + SOME_TIME_BEFORE_DEPARTURE + ANY));
        PATTERNS_EXCHANGE_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_FORBIDDEN + ANY + FareRulesParagraph16Parser.opt(EXCHANGE_CONDITION + ANY) + AFTER_DEPARTURE + ANY));
        PATTERNS_EXCHANGE_FORBIDDEN.add(FareRulesParagraph16Parser.pattern(ANY + EXCHANGE_FORBIDDEN + DOT + ANY));
    }
}

