/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.getFareRules;

import com.gridnine.xtrip.common.gds.model.FareRuleParagraph;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.getFareRules.FareRulesRequestParameters;
import com.gridnine.xtrip.server.gds.sirena2000.model.FareremarkAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FareRulesResponseParser
extends BaseProcessor {
    private static Pattern fareRemarkTitleSplitPattern = Pattern.compile("^<b>(\\d+)\\. *(.*)</b>$", 8);

    public void process(MessageContext ctx) throws Exception {
        FareremarkAnswer answer = (FareremarkAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        FareRulesRequestParameters parameters = (FareRulesRequestParameters)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.FARE_REMARKS_REQUEST_PARAMETERS);
        ArrayList<FareRuleParagraph> rules = (ArrayList<FareRuleParagraph>)ctx.getObject((Enum)IBusGdsContextKeys.FARE_RULES);
        if (rules == null) {
            rules = new ArrayList<FareRuleParagraph>();
            ctx.putObject((Enum)IBusGdsContextKeys.FARE_RULES, rules);
        }
        rules.addAll(this.parseRemarks(answer, parameters));
    }

    private List<FareRuleParagraph> parseRemarks(FareremarkAnswer answer, FareRulesRequestParameters parameters) {
        ArrayList<FareRuleParagraph> rules = new ArrayList<FareRuleParagraph>();
        for (String remark : answer.getRemarks()) {
            Matcher m = fareRemarkTitleSplitPattern.matcher(remark);
            if (m.find()) {
                boolean hasFoundNextPart;
                do {
                    String numberStr = m.group(1);
                    String titleStr = m.group(2);
                    int textStartPos = m.end();
                    hasFoundNextPart = m.find();
                    String textStr = hasFoundNextPart ? remark.substring(textStartPos, m.start()) : remark.substring(textStartPos);
                    FareRuleParagraph frp = new FareRuleParagraph();
                    frp.setTitle(titleStr);
                    frp.setNumber(numberStr);
                    frp.setContent(textStr);
                    rules.add(frp);
                } while (hasFoundNextPart);
                continue;
            }
            FareRuleParagraph frp = new FareRuleParagraph();
            frp.setTitle("\u0423\u041f\u0422 \u0434\u043b\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 " + parameters.getPassengerType().toString());
            frp.setContent(remark);
            rules.add(frp);
        }
        return rules;
    }
}

