/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.getFareRules;

import com.gridnine.xtrip.common.gds.model.FareRuleParagraph;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.getFareRules.FareRulesParagraph16Parser;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;

public class GetPenaltiesInfoFromFareRulesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List rules = (List)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_RULES);
        if (rules.isEmpty()) {
            this.log.error("No fare rules to parse");
            return;
        }
        FareRuleParagraph p16 = rules.stream().filter(rule -> rule.getNumber().equals("16")).findFirst().orElse(null);
        if (p16 == null) {
            this.log.info("No paragraph 16 in the fare rules");
            return;
        }
        Map<String, PenaltiesInfo> penaltiesInfo = FareRulesParagraph16Parser.get().getPenaltiesInfo(p16);
        ctx.putObject((Enum)IBusGdsContextKeys.PENALTIES_INFO, penaltiesInfo);
    }
}

