/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.getItinReceiptsData;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetItinReceiptsDataAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class GetItinReceiptsDataResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GetItinReceiptsDataAnswer answer = (GetItinReceiptsDataAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        int docNum = 0;
        for (GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm : answer.getReceipts().getTicketForms()) {
            ++docNum;
            Product prod = this.findProduct(reservation, ticketForm);
            if (prod == null) {
                ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e \u041c\u041a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0431\u0438\u043b\u0435\u0442 \u0434\u043b\u044f \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438 {0}", (Object[])new Object[]{docNum}));
                continue;
            }
            if (ProductCategory.MCO.equals((Object)prod.getProductCategory())) {
                this.updateMcoProduct(prod, ticketForm);
            } else {
                this.updateProduct(prod, ticketForm);
            }
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u043e \u041c\u041a \u0434\u043b\u044f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430 {0} \u0438 \u0431\u0438\u043b\u0435\u0442\u0430 {1}", (Object[])new Object[]{prod.getTraveller().getName(), prod.getSystemNumber()}));
        }
    }

    private Product findProduct(Reservation reservation, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        String passengerId = ticketForm.getPassId();
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product prod = (Product)baseProduct;
            String emdNum = ticketForm.getEmdNum();
            if (TextUtil.isBlank((String)emdNum) ? (passengerId == null ? !this.matchPassportData(prod, ticketForm) : !passengerId.equals(prod.getGdsId())) || !this.matchSegments(prod, ticketForm) : !this.matchPassportData(prod, ticketForm) || !emdNum.replaceAll("\\s+", "").substring(3).equals(prod.getSystemNumber())) continue;
            return prod;
        }
        return null;
    }

    private boolean matchPassportData(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        Passport pspt = prod.getTraveller().getPassport();
        if (pspt == null || TextUtil.isBlank((String)pspt.getNumber())) {
            return false;
        }
        String psptNumber = this.normalizePassportNumber(pspt.getNumber());
        String psptData = ticketForm.getDocOfPassenger().trim();
        return !TextUtil.isBlank((String)psptData) && psptData.contains(psptNumber);
    }

    private String normalizePassportNumber(String number) {
        StringBuilder result = new StringBuilder();
        for (char c : number.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            result.append(c);
        }
        return result.toString();
    }

    private boolean matchSegments(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        for (GetItinReceiptsDataAnswer.Receipts.TicketForm.Itinerary.Itin itin : ticketForm.getItinerary().getItins()) {
            if (this.findSegment(prod, itin) == null) continue;
            return true;
        }
        return false;
    }

    void updateValidator(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        EntityStorage es = EntityStorage.get();
        if (ticketForm.getPlaceOfIssue() != null && !ticketForm.getPlaceOfIssue().getVlds().isEmpty()) {
            boolean validatorRead = false;
            boolean agentRead = false;
            block0: for (String vld : ticketForm.getPlaceOfIssue().getVlds()) {
                if (agentRead && validatorRead) break;
                String[] parts = vld.split("\\s");
                if (parts.length < 2) continue;
                for (String str : parts) {
                    if (TextUtil.isBlank((String)str)) continue;
                    if (!validatorRead) {
                        ValidatorIndex validatorIndex;
                        SearchQuery q = new SearchQuery();
                        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.number.name(), (Object)str));
                        q.getCriteria().getCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.salesPoint.name(), (Object)prod.getSalesPoint()));
                        List validators = es.search(ValidatorIndex.class, q).getData();
                        if (validators.size() == 0) continue block0;
                        if (validators.size() == 1) {
                            validatorIndex = (ValidatorIndex)validators.get(0);
                        } else {
                            Optional<ValidatorIndex> opt = validators.stream().filter(v -> prod.getPcc().equalsIgnoreCase(v.getPcc())).findAny();
                            if (!opt.isPresent()) {
                                throw Xeption.forAdmin((String)"\u0412 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c {1} \u0438 pcc {2}", (Object[])new Object[]{prod.getSalesPoint(), str, prod.getPcc()});
                            }
                            validatorIndex = opt.get();
                        }
                        prod.setValidatorCode(str);
                        prod.setValidatorRef(new NestedEntityReference(prod.getSalesPoint(), validatorIndex.getNavigationKey(), Validator.class, validatorIndex.toString()));
                        validatorRead = true;
                        continue;
                    }
                    if (agentRead) continue;
                    prod.setCashierCode(str);
                    agentRead = true;
                }
            }
        }
    }

    private void updateProduct(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        String tourCode;
        this.updateValidator(prod, ticketForm);
        prod.setEndorsement(ticketForm.getEndorsementsRestrictions());
        prod.setFareCalculationData(ticketForm.getFareCalculation());
        for (GetItinReceiptsDataAnswer.Receipts.TicketForm.Itinerary.Itin itin : ticketForm.getItinerary().getItins()) {
            Segment seg = this.findSegment(prod, itin);
            if (seg == null) continue;
            seg.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)itin.getLuggNorm()));
            seg.setNotValidBefore(this.parseDate(itin.getMinvis(), seg.getStartDate()));
            seg.setNotValidAfter(this.parseDate(itin.getMaxvis(), seg.getEndDate()));
            seg.setStatus(itin.getStatus());
        }
        String airlineLocator = ticketForm.getOtherRegnum();
        if (!TextUtil.isBlank((String)airlineLocator)) {
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    seg.setAirlineLocator(airlineLocator);
                }
            }
        }
        if (!TextUtil.isBlank((String)(tourCode = ticketForm.getTourCode()))) {
            prod.setTourCode(tourCode);
        }
        prod.setSirenaQrLink(ticketForm.getQrLink());
        StringBuilder emdIdentifier = new StringBuilder();
        if (ticketForm.getAirlineData() != null) {
            emdIdentifier.append(ticketForm.getAirlineData().getRegNumber()).append("/").append(ticketForm.getAirlineData().getCba()).append(" ");
        }
        emdIdentifier.append(ticketForm.getOtherRegnum());
        prod.setSirenaEmdIdentifier(emdIdentifier.toString());
    }

    private void updateMcoProduct(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm) {
        String tourCode;
        this.updateValidator(prod, ticketForm);
        prod.setEndorsement(ticketForm.getEndorsementsRestrictions());
        prod.setFareCalculationData(ticketForm.getFareCalculation());
        String airlineLocator = ticketForm.getOtherRegnum();
        if (!TextUtil.isBlank((String)airlineLocator)) {
            for (SegmentTariff st : prod.getSegmentTariffs()) {
                for (Segment seg : st.getSegments()) {
                    seg.setAirlineLocator(airlineLocator);
                }
            }
        }
        if (!TextUtil.isBlank((String)(tourCode = ticketForm.getTourCode()))) {
            prod.setTourCode(tourCode);
        }
        prod.setSirenaQrLink(ticketForm.getQrLink());
    }

    private Date parseDate(String str, Date base) {
        if (TextUtil.isBlank((String)str) || base == null) {
            return null;
        }
        try {
            Calendar cldr = Calendar.getInstance();
            cldr.setTime(base);
            return new SimpleDateFormat("ddMMyyyy").parse(str + new DecimalFormat("0000").format(cldr.get(1)));
        }
        catch (ParseException pe) {
            this.log.warn("failed parsing date " + str, (Throwable)pe);
            return null;
        }
    }

    private Segment findSegment(Product prod, GetItinReceiptsDataAnswer.Receipts.TicketForm.Itinerary.Itin itin) {
        String airlineCode = itin.getAwk();
        String flightNum = itin.getFlight();
        if (TextUtil.isBlank((String)airlineCode) || TextUtil.isBlank((String)flightNum)) {
            return null;
        }
        airlineCode = airlineCode.trim();
        flightNum = flightNum.trim();
        DictionaryReference airline = SirenaHelper.resolveNativeCode(Airline.class, (String)airlineCode);
        for (SegmentTariff st : prod.getSegmentTariffs()) {
            for (Segment seg : st.getSegments()) {
                if (!MiscUtil.equals((Object)airline, (Object)seg.getAirline()) || !flightNum.equals(seg.getFlightNo())) continue;
                return seg;
            }
        }
        return null;
    }
}

