/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.model;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.Tickinfo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;

public class SirenaModelHelper {
    public static Pnr.Prices.Price getPrice(Pnr pnr, String passengerId, String segmentId) {
        for (Pnr.Prices.Price price : pnr.getPrices().getPrices()) {
            if (!passengerId.equals(price.getPassengerId()) || !segmentId.equals(price.getSegmentId())) continue;
            return price;
        }
        return null;
    }

    public static Product findProduct(Reservation reservation, Collection<Tickinfo> tickinfos) {
        block0: for (BaseProduct product : reservation.getProducts()) {
            Product ticket = (Product)product;
            HashSet<String> segmentIds = new HashSet<String>();
            for (Tickinfo tickinfo : tickinfos) {
                if (ticket.getGdsId() == null || !ticket.getGdsId().equals(tickinfo.getPassId())) continue block0;
                segmentIds.add(tickinfo.getSegId());
            }
            for (Segment segment : AirProductHelper.getSegments((Collection)ticket.getSegmentTariffs())) {
                if (segmentIds.remove(segment.getGdsId())) continue;
                continue block0;
            }
            if (!segmentIds.isEmpty()) continue;
            return ticket;
        }
        return null;
    }

    public static void addFareAndTaxes(Product product, SegmentTariff st, Pnr.Prices.Price price) {
        ProductFare fare = new ProductFare();
        fare.setEquivalentFare(new BigDecimal(price.getFare().getValue().getValue()));
        Money baseFare = new Money();
        if (price.getFare().getFareValue() != null) {
            if ("NUC".equals(price.getFare().getFareValue().getCurrency())) {
                fare.setNucFare(new BigDecimal(price.getFare().getFareValue().getValue()));
                baseFare.setValue(fare.getEquivalentFare());
                baseFare.setCurrency(DictHelper.getEquivCurrency());
            } else {
                baseFare.setValue(new BigDecimal(price.getFare().getFareValue().getValue()));
                baseFare.setCurrency(price.getFare().getFareValue().getCurrency());
            }
        } else {
            baseFare.setValue(fare.getEquivalentFare());
            baseFare.setCurrency(DictHelper.getEquivCurrency());
        }
        fare.setBaseFare(baseFare);
        fare.setSegmentTariff(st);
        product.getFares().add(fare);
        if (price.getTaxes() != null) {
            for (Pnr.Prices.Price.Taxes.Tax tax : price.getTaxes().getTaxes()) {
                String code = tax.getCode();
                BigDecimal amount = new BigDecimal(tax.getValue());
                if (code != null && code.length() == 1) {
                    ProductFare addFare = new ProductFare();
                    product.getFares().add(addFare);
                    addFare.setSegmentTariff(st);
                    addFare.setEquivalentFare(amount);
                    Money addFareMoney = new Money();
                    if (tax.getTaxValue() != null && !"NUC".equals(tax.getTaxValue().getCurrency())) {
                        addFareMoney.setCurrency(tax.getTaxValue().getCurrency());
                        addFareMoney.setValue(new BigDecimal(tax.getTaxValue().getValue()));
                    } else {
                        addFareMoney.setCurrency(DictHelper.getEquivCurrency());
                        addFareMoney.setValue(amount);
                    }
                    addFare.setBaseFare(addFareMoney);
                    continue;
                }
                Tax t = new Tax();
                product.getTaxes().add(t);
                t.setSegmentTariff(st);
                t.setCode(code);
                t.setEquivalentAmount(amount);
            }
        }
    }
}

