/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.mtd;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.MtdParameters;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettingsSsr;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.TripGoal;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.BookingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.mtd.SirenaMtdHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Iterator;

public class BookingQueryAddMtdSsrsProcessor
extends BaseProcessor {
    private static String buildText(String text, MtdParameters parameters, GdsTraveller gdsTraveller) {
        String result = text;
        if (result.contains("${mtdNumber}")) {
            result = result.replaceAll("\\$\\{mtdNumber\\}", parameters.getMtdNumber());
        }
        if (result.contains("${passengerStatusRus}")) {
            result = result.replaceAll("\\$\\{passengerStatusRus\\}", BookingQueryAddMtdSsrsProcessor.formatPassengerStatusRus(parameters.getPassengerStatus()));
        }
        if (result.contains("${passengerStatusEng}")) {
            result = result.replaceAll("\\$\\{passengerStatusEng\\}", SirenaHelper.convertPassengerStatusToIata((PassengerStatus)parameters.getPassengerStatus()));
        }
        if (result.contains("${tripGoal}")) {
            result = result.replaceAll("\\$\\{tripGoal\\}", BookingQueryAddMtdSsrsProcessor.formatTripGoal(parameters.getTripGoal()));
        }
        if (gdsTraveller != null && result.contains("${inf}")) {
            result = result.replaceAll("\\$\\{inf\\}", GdsDictHelper.isWithoutSeat((DictionaryReference)gdsTraveller.getPassengerType()) ? "INF" : "");
        }
        return result;
    }

    public void process(MessageContext ctx) throws Exception {
        EntityContainer<SirenaMtdFareSettings> settingsCtr = SirenaMtdHelper.getSirenaMtdFareSettingsContainer(ctx);
        if (settingsCtr == null) {
            return;
        }
        MtdParameters parameters = SirenaMtdHelper.getMtdParameters(ctx);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        if (((SirenaMtdFareSettings)settingsCtr.getEntity()).getSsrs().isEmpty()) {
            return;
        }
        BookingQuery query = (BookingQuery)request.getQuery();
        SirenaServerHelper.addSsrSectionIfMissing(query);
        GdsReservationCreationParameters grcp = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        int nSegs = FlightHelper.getSegments((Flight)grcp.getFlight()).size();
        int nTravs = grcp.getGdsTravellers().size();
        for (SirenaMtdFareSettingsSsr ssrSettings : ((SirenaMtdFareSettings)settingsCtr.getEntity()).getSsrs()) {
            for (int segIdx = 0; segIdx < (ssrSettings.isAllSegments() ? nSegs : 1); ++segIdx) {
                Iterator gdsTravellerIterator = grcp.getGdsTravellers().iterator();
                for (int travIdx = 0; travIdx < (ssrSettings.isAllPassengers() ? nTravs : 1); ++travIdx) {
                    BookingQuery.SpecialServices.Ssrs.Ssr ssr = new BookingQuery.SpecialServices.Ssrs.Ssr();
                    ssr.setType(ssrSettings.getCode());
                    ssr.setText(BookingQueryAddMtdSsrsProcessor.buildText(ssrSettings.getText(), parameters, ssrSettings.isAllPassengers() ? (GdsTraveller)gdsTravellerIterator.next() : null));
                    if (ssrSettings.isAllSegments()) {
                        ssr.setSegId(Integer.toString(segIdx + 1));
                    }
                    if (ssrSettings.isAllPassengers()) {
                        ssr.setPassId(Integer.toString(travIdx + 1));
                    }
                    query.getSpecialServices().getSsrs().getSsrs().add(ssr);
                }
            }
        }
    }

    private static String formatTripGoal(TripGoal tripGoal) {
        switch (tripGoal) {
            case VACATION: {
                return "\u041e\u0422\u041f\u0423\u0421\u041a";
            }
            case MISSION: {
                return "\u041a\u041e\u041c\u0410\u041d\u0414\u0418\u0420\u041e\u0412\u041a\u0410";
            }
            case BURIAL_SITE: {
                return "\u041a \u041c\u0415\u0421\u0422\u0423 \u0417\u0410\u0425\u041e\u0420\u041e\u041d\u0415\u041d\u0418\u042f";
            }
            case TRANSFER_TO_NEW_LOCATION: {
                return "\u041f\u0415\u0420\u0415\u0412\u041e\u0414 \u041a \u041d\u041e\u0412\u041e\u041c\u0423 \u041c\u0415\u0421\u0422\u0423 \u0421\u041b\u0423\u0416\u0411\u042b";
            }
            case OTHER: {
                return "\u0418\u041d\u041e\u0415";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected trip goal {0}", (Object[])new Object[]{tripGoal});
    }

    private static String formatPassengerStatusRus(PassengerStatus passengerStatus) {
        switch (passengerStatus) {
            case VS_OVD: {
                return "\u041c\u0412\u0414 \u041e\u0412\u0414";
            }
            case VS_VV: {
                return "\u041c\u0412\u0414 \u0412\u0412";
            }
            case VS_OVD_KSK: {
                return "\u041c\u0412\u0414 \u041e\u0412\u0414 \u041a\u0421\u041a";
            }
        }
        throw Xeption.forDeveloper((String)"unexpected passenger status {0}", (Object[])new Object[]{passengerStatus});
    }
}

