/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.mtd;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.gdsTracing.GdsTracingItemBuilder;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.GdsTracingSettings;
import com.gridnine.xtrip.common.gds.model.MtdSearchParameters;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.mtd.IBusGdsSirenaMtdContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FilterFlightsByMtdFareSettings
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsTracingItemBuilder builder = null;
        GdsTracingSettings gdsTracingSettings = (GdsTracingSettings)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_SETTINGS);
        if (gdsTracingSettings != null && gdsTracingSettings.isActive() && gdsTracingSettings.isSaveSearchTraces()) {
            builder = (GdsTracingItemBuilder)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_TRACING_ITEM_BUILDER);
        }
        Map settingsGroup = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaMtdContextKeys.SIRENA_MTD_FARE_SETTINGS_GROUP);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Map<DictionaryReference, List<Flight>> flightsByCarrier = flights.stream().collect(Collectors.groupingBy(flight -> flight.getCarrier()));
        MtdSearchParameters parameters = (MtdSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MTD_FLIGHT_SEARCH_PARAMETERS);
        for (Map.Entry<DictionaryReference, List<Flight>> entry : flightsByCarrier.entrySet()) {
            Set excludeBookingClasses;
            Set excludeFareBasises;
            Set bookingClasses;
            Set fareBasises;
            EntityContainer settingsCtr = (EntityContainer)settingsGroup.get(entry.getKey());
            if (settingsCtr == null) {
                for (Flight flight2 : entry.getValue()) {
                    flights.remove(flight2);
                    if (builder == null) continue;
                    builder.traceFlightLogic((BaseEntity)flight2, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0438\u0437-\u0437\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0438\u044f \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0412\u041f\u0414 \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430");
                }
                continue;
            }
            switch (parameters.getServiceClass()) {
                case ECONOMY: {
                    fareBasises = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getFareBasises();
                    bookingClasses = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getBookingClasses();
                    excludeFareBasises = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getExcludeFareBasises();
                    excludeBookingClasses = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getExcludeBookingClasses();
                    break;
                }
                case BUSINESS: {
                    fareBasises = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getBusinessFareBasises();
                    bookingClasses = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getBusinessBookingClasses();
                    excludeFareBasises = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getBusinessExcludeFareBasises();
                    excludeBookingClasses = ((SirenaMtdFareSettings)settingsCtr.getEntity()).getBusinessExcludeBookingClasses();
                    break;
                }
                default: {
                    throw Xeption.forDeveloper((String)"unexpected service class {0}", (Object[])new Object[]{parameters.getServiceClass()});
                }
            }
            if (fareBasises.isEmpty() && bookingClasses.isEmpty() && excludeFareBasises.isEmpty() && excludeBookingClasses.isEmpty()) continue;
            block6: for (Flight flight3 : entry.getValue()) {
                for (FlightSegment fs : FlightHelper.getSegments((Flight)flight3)) {
                    if (!bookingClasses.isEmpty() && !bookingClasses.contains(fs.getBookingClass())) {
                        flights.remove(flight3);
                        if (builder == null) continue block6;
                        builder.traceFlightLogic((BaseEntity)flight3, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0438\u0437-\u0437\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u043a\u043b\u0430\u0441\u0441\u0443 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        continue block6;
                    }
                    if (!fareBasises.isEmpty()) {
                        for (FareInfo fi : fs.getFareInfos()) {
                            if (fareBasises.contains(fi.getFareBasis())) continue;
                            flights.remove(flight3);
                            if (builder == null) continue block6;
                            builder.traceFlightLogic((BaseEntity)flight3, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0438\u0437-\u0437\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u043a\u043e\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u0430");
                            continue block6;
                        }
                    }
                    if (!excludeBookingClasses.isEmpty() && excludeBookingClasses.contains(fs.getBookingClass())) {
                        flights.remove(flight3);
                        if (builder == null) continue block6;
                        builder.traceFlightLogic((BaseEntity)flight3, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0438\u0437-\u0437\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u043a\u043b\u0430\u0441\u0441\u0443 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        continue block6;
                    }
                    if (excludeFareBasises.isEmpty()) continue;
                    for (FareInfo fi : fs.getFareInfos()) {
                        if (!excludeFareBasises.contains(fi.getFareBasis())) continue;
                        flights.remove(flight3);
                        if (builder == null) continue block6;
                        builder.traceFlightLogic((BaseEntity)flight3, MessageType.MESSAGE, "\u043f\u0435\u0440\u0435\u043b\u0435\u0442 \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u0437 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0438\u0437-\u0437\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u043a\u043e\u0434\u0443 \u0442\u0430\u0440\u0438\u0444\u0430");
                        continue block6;
                    }
                }
            }
        }
    }
}

