/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.mtd;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.MtdSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.mtd.IBusGdsSirenaMtdContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.mtd.SirenaMtdHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class PrepareFlightSearchParametersInContextProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SeatPreferences sp;
        EntityContainer<SirenaMtdFareSettings> settingsCtr;
        MtdSearchParameters parameters = (MtdSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MTD_FLIGHT_SEARCH_PARAMETERS);
        Map settingsGroup = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaMtdContextKeys.SIRENA_MTD_FARE_SETTINGS_GROUP);
        FlightSearchParameters fsp = new FlightSearchParameters();
        fsp.setSkipConnected(true);
        fsp.getRoute().add(parameters.getRouteSegment());
        if (settingsGroup.keySet().size() == 1) {
            fsp.getPreferredAirlines().add(settingsGroup.keySet().iterator().next());
        }
        if (this.serviceClassNeeded(parameters, (SirenaMtdFareSettings)(settingsCtr = SirenaMtdHelper.getSirenaMtdFareSettingsContainer(ctx)).getEntity())) {
            fsp.setServiceClass(parameters.getServiceClass());
        }
        EntityContainer anySettingsCtr = (EntityContainer)settingsGroup.values().iterator().next();
        if (parameters.getAdultsCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(((SirenaMtdFareSettings)anySettingsCtr.getEntity()).getAdultPassengerType());
            sp.setCount(parameters.getAdultsCount());
            fsp.getSeats().add(sp);
        }
        if (parameters.getChildrenCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(((SirenaMtdFareSettings)anySettingsCtr.getEntity()).getChildPassengerType());
            sp.setCount(parameters.getChildrenCount());
            fsp.getSeats().add(sp);
        }
        if (parameters.getInfantsCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(((SirenaMtdFareSettings)anySettingsCtr.getEntity()).getInfantPassengerType());
            sp.setCount(parameters.getInfantsCount());
            fsp.getSeats().add(sp);
        }
        if (parameters.getInfantsWithSiteCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(((SirenaMtdFareSettings)anySettingsCtr.getEntity()).getInfantWithSitePassengerType());
            sp.setCount(parameters.getInfantsWithSiteCount());
            fsp.getSeats().add(sp);
        }
        if (settingsGroup.keySet().size() == 1) {
            fsp.getPreferredAirlines().add(settingsGroup.keySet().iterator().next());
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
    }

    private boolean serviceClassNeeded(MtdSearchParameters parameters, SirenaMtdFareSettings mtdSettings) {
        return parameters.getServiceClass() != ClassOfService.ECONOMY || parameters.getPassengerStatus() != PassengerStatus.VS_MO || mtdSettings.getAirline() == null || !"HZ".equals(mtdSettings.getAirline().getCode());
    }
}

