/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.mtd;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.MtdParameters;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.mtd.model.SirenaMtdFareSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.TranslitUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.mtd.IBusGdsSirenaMtdContextKeys;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class SirenaMtdHelper {
    public static EntityContainer<SirenaMtdFareSettings> getSirenaMtdFareSettingsContainer(MessageContext ctx) {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight != null) {
            if (flight.getMtdSettings() != null) {
                return EntityStorage.get().resolve(flight.getMtdSettings());
            }
            return null;
        }
        Map settingsGroup = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaMtdContextKeys.SIRENA_MTD_FARE_SETTINGS_GROUP);
        return (EntityContainer)settingsGroup.values().iterator().next();
    }

    public static MtdParameters getMtdParameters(MessageContext ctx) {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (flight != null) {
            return flight.getMtdParameters();
        }
        return (MtdParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.MTD_FLIGHT_SEARCH_PARAMETERS);
    }

    public static String buildFormpayNum(MtdParameters parameters, SirenaMtdFareSettings settings) {
        StringBuilder sb = new StringBuilder("\u0412\u041f\u0414 ");
        String mtdNumber = parameters.getMtdNumber();
        if (TextUtil.isCyrillic((String)mtdNumber, (boolean)true) && settings.isFormPayMtdSeriesInLatin()) {
            mtdNumber = TranslitUtil.cyr2lat((String)mtdNumber, (TranslitUtil.TranslitRules)TranslitUtil.TranslitRules.SIRENA);
        }
        sb.append(mtdNumber);
        sb.append(' ');
        sb.append(SirenaHelper.convertPassengerStatusToCrt((PassengerStatus)parameters.getPassengerStatus()));
        sb.append(' ');
        sb.append("\u0420\u0424");
        return sb.toString();
    }
}

