/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.paymentExtAuth;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PaymentExtAuthQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class PaymentExtAuthQueryBuilder
extends BaseProcessor {
    private boolean pretend;
    private String action;
    private String mode;

    public void configure(Map<String, String> parameters) {
        this.action = parameters.get("action");
        this.mode = parameters.get("mode");
        if (parameters.containsKey("pretend")) {
            this.pretend = Boolean.parseBoolean(parameters.get("pretend"));
        }
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        SirenaRequest<PaymentExtAuthQuery> request = this.buildRequest(reservation);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, request);
    }

    private SirenaRequest<PaymentExtAuthQuery> buildRequest(Reservation reservation) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(reservation));
        request.setSecure(true);
        request.setPrivileged(true);
        return request;
    }

    private PaymentExtAuthQuery buildQuery(Reservation reservation) {
        PaymentExtAuthQuery query = new PaymentExtAuthQuery();
        query.setAction(this.action);
        query.setMode(this.mode);
        query.setRegnum(SirenaHelper.getRecordLocator((Reservation)reservation));
        query.setSurname(SirenaHelper.getSurname((Reservation)reservation));
        if (this.pretend) {
            PaymentExtAuthQuery.RequestParams rp = new PaymentExtAuthQuery.RequestParams();
            rp.setPretend(Boolean.TRUE);
            query.setRequestParams(rp);
        }
        return query;
    }
}

