/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.pricing;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class PricingAddParamsProcessor
extends BaseProcessor {
    private String minResults;

    public void configure(Map<String, String> parameters) {
        this.minResults = parameters.get("min-results");
    }

    public void process(MessageContext ctx) {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        String minResultsPrior = (String)ctx.getObject((Enum)IBusGdsSirenaContextKeys.PRICING_MIN_RESULTS);
        AbstractPricingQuery.RequestParams rp = ((AbstractPricingQuery)request.getQuery()).getRequestParams();
        if (rp == null) {
            rp = new AbstractPricingQuery.RequestParams();
            ((AbstractPricingQuery)request.getQuery()).setRequestParams(rp);
        }
        rp.setTickSer("\u042d\u0411\u041c");
        rp.setAsynchronousFares(Boolean.FALSE);
        rp.setEtIfPossible(Boolean.TRUE);
        rp.setFingeringOrder(AbstractPricingQuery.RequestParams.FingeringOrder.DIFFERENT_FLIGHTS_COMB_FIRST);
        AbstractPricingQuery.RequestParams.Formpay formpay = new AbstractPricingQuery.RequestParams.Formpay();
        formpay.setValue("cash");
        rp.setFormpay(formpay);
        if (fsp != null) {
            rp.setMaxResults(fsp.getLimit() != null ? fsp.getLimit() : 200);
            if (fsp.isExcludeBaglessFares()) {
                rp.setPtBaggage(Boolean.TRUE);
            }
            rp.setMixAc(!fsp.isExcludeMultiTicket());
        }
        rp.setMinResults(minResultsPrior != null ? minResultsPrior : this.minResults);
        rp.setMixScls(Boolean.TRUE);
        rp.setPriceChildAaa(Boolean.TRUE);
        rp.setTimeout(40);
        AbstractPricingQuery.AnswerParams ap = ((AbstractPricingQuery)request.getQuery()).getAnswerParams();
        if (ap == null) {
            ap = new AbstractPricingQuery.AnswerParams();
            ((AbstractPricingQuery)request.getQuery()).setAnswerParams(ap);
        }
        ap.setLang("ru");
        ap.setMarkCityport(Boolean.TRUE);
        ap.setReferencStyleCodes(Boolean.TRUE);
        ap.setRegroup(Boolean.FALSE);
        ap.setShowAvailable(Boolean.TRUE);
        ap.setShowBaseclass(Boolean.TRUE);
        ap.setShowEt(Boolean.TRUE);
        ap.setShowFareexpdate(Boolean.TRUE);
        ap.setShowFlighttime(Boolean.TRUE);
        ap.setShowIoMatching(Boolean.TRUE);
        ap.setShowNBlanks(Boolean.TRUE);
        ap.setShowRegLatin(Boolean.TRUE);
        ap.setShowRegroupIoMatching(Boolean.TRUE);
        ap.setShowTml(Boolean.TRUE);
        ap.setShowUptRec(Boolean.TRUE);
        ap.setShowVarianttotal(Boolean.TRUE);
        ap.setSplitCompanies(Boolean.FALSE);
        if (fsp == null || !fsp.isExcludeAncillaryFees()) {
            ap.setShowSvc(Boolean.TRUE);
        }
        ap.setShowBrandInfo(Boolean.TRUE);
    }
}

