/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.pricing;

import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;

public class PricingAddPassengersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        List seats = IBusGdsHelper.getSeats((MessageContext)ctx);
        for (SeatPreferences entry : seats) {
            PassengerType originalPassengerType = (PassengerType)DictionaryCache.get().resolveReference(entry.getOriginalPassengerType());
            PassengerType passengerType = (PassengerType)DictionaryCache.get().resolveReference(entry.getPassengerType());
            AbstractPricingQuery.Passenger passenger = new AbstractPricingQuery.Passenger();
            passenger.setCode(SirenaHelper.getNativeCode((DictionaryReference)entry.getPassengerType()));
            passenger.setCount(entry.getCount());
            passenger.setAge(originalPassengerType != null ? originalPassengerType.getSirenaAge() : passengerType.getSirenaAge());
            PassengerTypeValue ptv = DictHelper.getPassengerTypeValue((DictionaryReference)entry.getPassengerType());
            if (ptv == PassengerTypeValue.YOUTH) {
                passenger.setDoc("\u041f\u0421");
            }
            passenger.setDoc2(entry.getDiscountCode());
            ((AbstractPricingQuery)request.getQuery()).getPassengers().add(passenger);
        }
    }
}

