/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.pricing;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.FareRemarksContext;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Element;

public class PricingAnswerParser
extends BaseProcessor {
    private static final DateTimeFormatter JDTF_HH_MM_DD_MM_YYYY_UTC = DateTimeFormat.forPattern((String)"HH:mm dd.MM.yyyy").withZoneUTC();
    private static final java.time.format.DateTimeFormatter DTF_HH_MM_DD_MM_YYYY_UTC = java.time.format.DateTimeFormatter.ofPattern("HH:mm dd.MM.yyyy").withZone(ZoneId.of("UTC"));
    private static final DateTimeFormatter DTF_DD_MM_YY_HH_MM = DateTimeFormat.forPattern((String)"dd.MM.yy HH:mm");
    private static final DateTimeFormatter DTF_HH_MM = DateTimeFormat.forPattern((String)"HH:mm");
    private static final DateTimeFormatter DTF_YYYY_MM_DD_HH_MM_MSK = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm").withZone(DateTimeZone.forID((String)"Europe/Moscow"));

    public void process(MessageContext ctx) throws Exception {
        AbstractPricingAnswer answer = (AbstractPricingAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Collection<Flight> flights = this.parseResponse(answer);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
    }

    private Collection<Flight> parseResponse(AbstractPricingAnswer answer) throws Exception {
        ArrayList<Flight> result = new ArrayList<Flight>();
        if (answer.getVariants() != null) {
            for (AbstractPricingAnswer.Variant variant : answer.getVariants()) {
                result.add(this.parseFlight(variant, answer.getBrandInfos()));
            }
        }
        return result;
    }

    private Flight parseFlight(AbstractPricingAnswer.Variant variant, List<AbstractPricingAnswer.BrandInfo> brandInfos) throws Exception {
        Flight result = new Flight();
        result.setLatinRegistration(variant.getLatinRegistration().booleanValue());
        result.setSalesOriginProvider(SalesOriginProvider.SIRENA);
        result.setSalesOriginContent(SalesOriginContent.SIRENA);
        result.setAncillaryFeesRequestNeeded(true);
        result.setTicketCount(variant.getNBlanks().intValue());
        result.setGds(GdsName.SIRENA);
        String timeLimitStr = variant.getUtcTimelimit();
        if (!StringUtils.isBlank((String)timeLimitStr) && !"not-a-date-time".equals(timeLimitStr)) {
            result.setPqTimeLimit(JDTF_HH_MM_DD_MM_YYYY_UTC.parseDateTime(timeLimitStr).toDate());
        }
        result.setEticket(variant.getEtPossible().booleanValue());
        SirenaCustomPropertiesHelper.setRequestedBrands((Flight)result, (String)variant.getRequestedBrands());
        boolean firstFlight = true;
        for (AbstractPricingAnswer.Variant.Flight flight : variant.getFlights()) {
            AbstractPricingAnswer.Variant.Flight.Clazz clazz;
            AbstractPricingAnswer.Variant.Flight.Subclass subclass;
            Integer available;
            String operatingAirlineStr;
            FlightSegmentTariff fst = new FlightSegmentTariff();
            fst.setGds(GdsName.SIRENA);
            FlightSegment fs = new FlightSegment();
            fs.setGds(GdsName.SIRENA);
            Integer oSegmentPartNum = flight.getOSegmentPartNum();
            if (oSegmentPartNum != null) {
                fs.setStarting(oSegmentPartNum == 0);
            }
            fs.setAirline(SirenaHelper.resolveNativeCode(Airline.class, (String)flight.getCompany()));
            String string = operatingAirlineStr = StringUtils.isNotBlank((String)flight.getOperatingCompany()) ? flight.getOperatingCompany() : flight.getFranchiseCompany();
            if (!StringUtils.isBlank((String)operatingAirlineStr)) {
                fs.setOperatingAirline(SirenaHelper.resolveNativeCode(Airline.class, (String)operatingAirlineStr));
            } else {
                fs.setOperatingAirline(fs.getAirline());
            }
            fs.setFlightNumber(flight.getNum());
            fs.setLocationBegin(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)flight.getOrigin().getValue()));
            fs.setTerminalBegin(flight.getOrigin().getTerminal());
            fs.setLocationEnd(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)flight.getDestination().getValue()));
            fs.setTerminalEnd(flight.getDestination().getTerminal());
            fs.setDateBegin(DTF_DD_MM_YY_HH_MM.parseLocalDateTime(String.format("%s %s", flight.getDeptdate(), flight.getDepttime())).toDate());
            fs.setDateEnd(DTF_DD_MM_YY_HH_MM.parseLocalDateTime(String.format("%s %s", flight.getArrvdate(), flight.getArrvtime())).toDate());
            fs.setBoard(SirenaHelper.resolveNativeCode(Aircraft.class, (String)flight.getAirplane()));
            String flightTimeStr = flight.getFlightTime();
            if (!StringUtils.isBlank((String)flightTimeStr)) {
                if (flightTimeStr.contains(":")) {
                    fs.setTravelDuration(DTF_HH_MM.parseLocalTime(flightTimeStr).getMillisOfDay() / 60000);
                } else {
                    fs.setTravelDuration(Integer.parseInt(flightTimeStr));
                }
            }
            if ((available = flight.getAvailable()) != null) {
                fs.setAvailableSeats(available);
            }
            if ((subclass = flight.getSubclass()) != null) {
                fs.setBookingClass(subclass.getValue());
                fs.setServiceClass(SirenaHelper.parseClassOfService((String)subclass.getBaseclass()));
            }
            if ((clazz = flight.getClazz()) != null) {
                if (StringUtils.isBlank((String)fs.getBookingClass())) {
                    fs.setBookingClass(clazz.getValue());
                }
                if (fs.getServiceClass() == null) {
                    fs.setServiceClass(SirenaHelper.parseClassOfService((String)clazz.getBaseclass()));
                }
            }
            if (fs.getServiceClass() == null && !StringUtils.isBlank((String)fs.getBookingClass())) {
                fs.setServiceClass(FlightHelper.findClassOfService((DictionaryReference)fs.getAirline(), (DictionaryReference)fs.getOperatingAirline(), (String)fs.getBookingClass(), (boolean)DictHelper.isInternational((DictionaryReference)fs.getLocationBegin(), (DictionaryReference)fs.getLocationEnd())));
            }
            if (flight.getNLandings() != null) {
                fs.setStops(flight.getNLandings().intValue());
            }
            if (flight.getLegs() != null) {
                for (int i = 0; i < flight.getLegs().getLegs().size() - 1; ++i) {
                    AbstractPricingAnswer.Variant.Flight.Legs.Leg leg1 = flight.getLegs().getLegs().get(i);
                    AbstractPricingAnswer.Variant.Flight.Legs.Leg leg2 = flight.getLegs().getLegs().get(i + 1);
                    TechStopInfo tsi = new TechStopInfo();
                    tsi.setLocation(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)leg1.getArr().getValue()));
                    LocalDateTime dtArr = LocalDateTime.parse(leg1.getArr().getTimeLocal(), DTF_HH_MM_DD_MM_YYYY_UTC);
                    tsi.setArrivalDateTime(dtArr);
                    LocalDateTime dtDep = LocalDateTime.parse(leg2.getDep().getTimeLocal(), DTF_HH_MM_DD_MM_YYYY_UTC);
                    tsi.setDepartureDateTime(dtDep);
                    tsi.setDuration((int)ChronoUnit.MINUTES.between(dtArr, dtDep));
                    fs.getTechStopInfos().add(tsi);
                }
            }
            fst.getSegments().add(fs);
            result.getSegmentTariffs().add(fst);
            ImmutableListMultimap priceMMap = Multimaps.index(flight.getPrices(), price -> SirenaHelper.resolveNativeCode(PassengerType.class, (String)price.getOrigCode()));
            for (DictionaryReference passengerType : priceMMap.keySet()) {
                Collection prices = priceMMap.get((Object)passengerType);
                if (firstFlight) {
                    SeatPreferences sp = new SeatPreferences();
                    sp.setPassengerType(passengerType);
                    sp.setCount(prices.size());
                    result.getSeats().add(sp);
                }
                String lowestPassengerId = null;
                for (AbstractPricingAnswer.Variant.Flight.Price price2 : prices) {
                    String passengerId = price2.getPassengerId();
                    if (lowestPassengerId != null && MiscUtil.compare((Comparable)((Object)passengerId), (Comparable)((Object)lowestPassengerId)) >= 0) continue;
                    lowestPassengerId = passengerId;
                }
                if (lowestPassengerId == null) {
                    throw Xeption.forDeveloper((String)"lowest passenger id not found", (Object[])new Object[0]);
                }
                AbstractPricingAnswer.Variant.Flight.Price firstPrice = (AbstractPricingAnswer.Variant.Flight.Price)prices.iterator().next();
                String validatingCompanyStr = firstPrice.getValidatingCompany();
                SirenaCustomPropertiesHelper.setValidatingCompany((FlightSegmentTariff)fst, (String)validatingCompanyStr);
                if (result.getCarrier() == null) {
                    result.setCarrier(SirenaHelper.resolveNativeCode(Airline.class, (String)validatingCompanyStr));
                }
                SirenaCustomPropertiesHelper.setTicket((FlightSegmentTariff)fst, (String)firstPrice.getTicket());
                SirenaCustomPropertiesHelper.setBrand((FlightSegmentTariff)fst, (String)firstPrice.getBrand());
                for (AbstractPricingAnswer.Variant.Flight.Price price3 : prices) {
                    String fareExpDateStr;
                    Object brandNameRu;
                    String fareBasis;
                    if (!MiscUtil.equals((Object)lowestPassengerId, (Object)price3.getPassengerId())) continue;
                    FareInfo fareInfo = new FareInfo();
                    fareInfo.setPassengerType(passengerType);
                    FareRemarksContext remarksCtx = new FareRemarksContext();
                    remarksCtx.setAirline((DictionaryReference<Airline>)fs.getAirline());
                    Element uptElm = price3.getUpt();
                    if (uptElm != null) {
                        remarksCtx.getUptElements().put((DictionaryReference<PassengerType>)passengerType, uptElm);
                    }
                    if (StringUtils.isBlank((String)(fareBasis = price3.getFare().getCode())) && uptElm != null) {
                        fareBasis = XmlUtil.getValue((Element)uptElm, (String)"base_fare");
                    }
                    fareInfo.setFareBasis(fareBasis);
                    fareInfo.setRemarksSearchContext(XSUtil.toString((XSSerializable)remarksCtx));
                    fareInfo.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)price3.getBaggage()));
                    if (!StringUtils.isBlank((String)price3.getBrand())) {
                        FareDetails fareDetails = new FareDetails();
                        FarePricingParameters pricingParameters = new FarePricingParameters();
                        pricingParameters.setBrandId(price3.getBrand());
                        fareDetails.setPricingParameters(pricingParameters);
                        String brandNameEn = PricingAnswerParser.getBrandName(brandInfos, price3.getBrand(), "en");
                        if (!TextUtil.isBlank((String)brandNameEn)) {
                            L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)brandNameEn, (Locale)LocaleHelper.EN_LOCALE);
                        }
                        if (!TextUtil.isBlank((String)(brandNameRu = PricingAnswerParser.getBrandName(brandInfos, price3.getBrand(), "ru")))) {
                            L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)brandNameRu, (Locale)LocaleHelper.RU_LOCALE);
                        }
                        if (fareDetails.getBrandName().getValues().isEmpty()) {
                            String brandName = PricingAnswerParser.getBrandName(brandInfos, price3.getBrand(), null);
                            L10nStringHelper.setValue((L10nString)fareDetails.getBrandName(), (String)brandName, (Locale)Locale.ROOT);
                        }
                        fareInfo.setFareDetails(fareDetails);
                    }
                    fs.getFareInfos().add(fareInfo);
                    FlightFare fare = new FlightFare();
                    fare.setSegmentTariff(fst);
                    fare.setPassengerType(passengerType);
                    SirenaCustomPropertiesHelper.setPriceCode((FlightFare)fare, (String)price3.getCode());
                    BigDecimal equivalentFare = new BigDecimal(price3.getFare().getValue());
                    if (price3.getTaxes() != null) {
                        brandNameRu = price3.getTaxes().iterator();
                        while (brandNameRu.hasNext()) {
                            AbstractPricingAnswer.Variant.Flight.Price.Tax tax = (AbstractPricingAnswer.Variant.Flight.Price.Tax)brandNameRu.next();
                            String taxCode = tax.getCode();
                            if (taxCode == null || taxCode.length() != 1) continue;
                            equivalentFare = equivalentFare.add(new BigDecimal(tax.getValue()));
                        }
                    }
                    fare.setEquivalentAmount(equivalentFare);
                    result.getFares().add(fare);
                    if (price3.getTaxes() != null) {
                        for (AbstractPricingAnswer.Variant.Flight.Price.Tax tax : price3.getTaxes()) {
                            String taxCode = tax.getCode();
                            if (taxCode != null && taxCode.length() == 1) continue;
                            FlightTax ft = new FlightTax();
                            ft.setSegmentTariff(fst);
                            ft.setPassengerType(passengerType);
                            ft.setEquivalentAmount(new BigDecimal(tax.getValue()));
                            ft.setCode(taxCode);
                            result.getTaxes().add(ft);
                        }
                    }
                    if (StringUtils.isBlank((String)(fareExpDateStr = price3.getFare().getFareExpdate()))) continue;
                    Date fareExpDate = DTF_YYYY_MM_DD_HH_MM_MSK.parseDateTime(fareExpDateStr).toDate();
                    if (result.getPqTimeLimit() != null && !result.getPqTimeLimit().after(fareExpDate)) continue;
                    result.setPqTimeLimit(fareExpDate);
                }
            }
            firstFlight = false;
        }
        FlightHelper.fillMultiTicketBreakdown((Flight)result, SirenaCustomPropertiesHelper::getTicket, PricingAnswerParser::getCarrier);
        return result;
    }

    private static DictionaryReference<Airline> getCarrier(FlightSegmentTariff fst) {
        return SirenaHelper.resolveNativeCode(Airline.class, (String)SirenaCustomPropertiesHelper.getValidatingCompany((FlightSegmentTariff)fst));
    }

    private static String getBrandName(List<AbstractPricingAnswer.BrandInfo> brandInfos, String brand, String lang) {
        List<AbstractPricingAnswer.BrandInfo.BrandName> brandNames;
        Optional<AbstractPricingAnswer.BrandInfo> opt;
        if (brandInfos != null && (opt = brandInfos.stream().filter(bi -> brand.equals(bi.getId())).findAny()).isPresent() && (brandNames = opt.get().getBrandNames()) != null && !brandNames.isEmpty()) {
            if (lang != null) {
                Optional<AbstractPricingAnswer.BrandInfo.BrandName> langBrand = brandNames.stream().filter(bn -> lang.equals(bn.getLang())).findAny();
                if (langBrand.isPresent()) {
                    return langBrand.get().getValue();
                }
            } else {
                return brandNames.get(0).getValue();
            }
        }
        return null;
    }
}

