/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.queue;

import com.gridnine.xtrip.common.gds.model.AirlineMessage;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetPnrHistoryAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AirlineMessagesGetPnrHistoryAnswerParser
extends BaseProcessor {
    private static final Pattern P_HISTORY_ENTRY = Pattern.compile("\\(\\d+\\).*(\n .*)*");
    private static final Pattern P_ENTRY_HEADER = Pattern.compile("\\(\\d+\\) [^ ]+ (?<pcc>[^ ]+).*?(\n.*)?(?<date>\\d{2}(\u042f\u041d\u0412|\u0424\u0415\u0412|\u041c\u0410\u0420|\u0410\u041f\u0420|\u041c\u0410\u0419|\u0418\u042e\u041d|\u0418\u042e\u041b|\u0410\u0412\u0413|\u0421\u0415\u041d|\u041e\u041a\u0422|\u041d\u041e\u042f|\u0414\u0415\u041a)\\d+ \\d{2}\\:\\d{2}\\:\\d{2}).*");
    private static final Pattern P_SD_GENERIC = Pattern.compile(" \u0421\u0414 .*");
    private static final Pattern P_SD = Pattern.compile(" \u0421\u0414 (.*)??(?<type>[A-Z\u0410-\u042f]{4}) (?<message>[A-Z\u0410-\u042f0-9]{3} .*) +\\d{2}(\u042f\u041d\u0412|\u0424\u0415\u0412|\u041c\u0410\u0420|\u0410\u041f\u0420|\u041c\u0410\u0419|\u0418\u042e\u041d|\u0418\u042e\u041b|\u0410\u0412\u0413|\u0421\u0415\u041d|\u041e\u041a\u0422|\u041d\u041e\u042f|\u0414\u0415\u041a)\\d+ \\d{2}\\:\\d{2}\\:\\d{2}");
    private static final Pattern P_SI_GENERIC = Pattern.compile(" \u0421\u0418 .*");
    private static final Pattern P_SI = Pattern.compile(" \u0421\u0418 .*(?<type>[A-Z\u0410-\u042f]{4}) (\u0422\u0422|\u041d\u041a)\\/(?<message>[A-Z\u0410-\u042f]{2}\\d+ .*) \\d{2}(\u042f\u041d\u0412|\u0424\u0415\u0412|\u041c\u0410\u0420|\u0410\u041f\u0420|\u041c\u0410\u0419|\u0418\u042e\u041d|\u0418\u042e\u041b|\u0410\u0412\u0413|\u0421\u0415\u041d|\u041e\u041a\u0422|\u041d\u041e\u042f|\u0414\u0415\u041a)\\d+ \\d{2}\\:\\d{2}\\:\\d{2}");
    private static final Pattern IU_XS = Pattern.compile(" \u0422 +\u0412\u0425\u041e\u0414\u042f\u0429\u0410\u042f \u0422\u0415\u041b\u0415\u0413\u0420\u0410\u041c\u041c\u0410 .+\n( \u0418\u0423| \u0425\u0421) .+");
    private static final DateTimeFormatter DTF = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyy HH:mm:ss").toFormatter(new Locale("ru"));
    private static final Pattern MAY_PATTERN = Pattern.compile("(?iu)\u041c\u0410\u0419");

    public void process(MessageContext ctx) throws Exception {
        GetPnrHistoryAnswer answer = (GetPnrHistoryAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Matcher m1 = P_HISTORY_ENTRY.matcher(answer.getPnrHistory());
        ArrayList<AirlineMessage> result = new ArrayList<AirlineMessage>();
        while (m1.find()) {
            AirlineMessage msg;
            Matcher m4;
            String line;
            String entry = m1.group();
            Matcher m2 = P_ENTRY_HEADER.matcher(entry);
            if (!m2.find()) {
                throw Xeption.forDeveloper((String)("P_ENTRY_HEADER not matched:\n" + entry), (Object[])new Object[0]);
            }
            if (!"AIRIMP".equals(m2.group("pcc"))) continue;
            String dateStr = MAY_PATTERN.matcher(m2.group("date")).replaceAll("\u041c\u0410\u042f");
            LocalDateTime date = LocalDateTime.parse(dateStr, DTF);
            Matcher m3 = P_SD_GENERIC.matcher(entry);
            while (m3.find()) {
                line = m3.group();
                m4 = P_SD.matcher(line);
                if (!m4.matches()) {
                    throw Xeption.forDeveloper((String)("P_SD not matched:\n" + line), (Object[])new Object[0]);
                }
                msg = new AirlineMessage();
                msg.setDate(date);
                msg.setType(m4.group("type"));
                msg.setMessage(m4.group("message"));
                result.add(msg);
            }
            m3 = P_SI_GENERIC.matcher(entry);
            while (m3.find()) {
                line = m3.group();
                m4 = P_SI.matcher(line);
                if (!m4.matches()) {
                    throw Xeption.forDeveloper((String)("P_SI not matched:\n" + line), (Object[])new Object[0]);
                }
                msg = new AirlineMessage();
                msg.setDate(date);
                msg.setType(m4.group("type"));
                msg.setMessage(m4.group("message"));
                result.add(msg);
            }
            m3 = IU_XS.matcher(entry);
            if (!m3.find()) continue;
            AirlineMessage msg2 = new AirlineMessage();
            msg2.setDate(date);
            msg2.setType("QERR");
            result.add(msg2);
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.AIRLINE_MESSAGES, result);
    }
}

