/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.queue;

import com.gridnine.xtrip.common.gds.model.QueueWatchEventType;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetPnrHistoryAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HandledEventsGetPnrHistoryAnswerParser
extends BaseProcessor {
    private static final Pattern P = Pattern.compile(" \u0421\u0414 \u041f\u0420\u041e\u0427 \u041d\u041a0 +G9Q \\/ (?<type>[^ ]+) \\d+ (?<date>\\d{2}(\u042f\u041d\u0412|\u0424\u0415\u0412|\u041c\u0410\u0420|\u0410\u041f\u0420|\u041c\u0410\u0419|\u0418\u042e\u041d|\u0418\u042e\u041b|\u0410\u0412\u0413|\u0421\u0415\u041d|\u041e\u041a\u0422|\u041d\u041e\u042f|\u0414\u0415\u041a)\\d+ \\d{2}\\:\\d{2}\\:\\d{2})");
    private static final Map<Long, String> MONTHS = new HashMap<Long, String>();
    private static final DateTimeFormatter DTF;

    public void process(MessageContext ctx) throws Exception {
        GetPnrHistoryAnswer answer = (GetPnrHistoryAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Matcher m = P.matcher(answer.getPnrHistory());
        HashMap<QueueWatchEventType, LocalDateTime> result = new HashMap<QueueWatchEventType, LocalDateTime>();
        while (m.find()) {
            String type = m.group("type").replaceAll(Pattern.quote("."), "_");
            result.putIfAbsent(QueueWatchEventType.valueOf((String)type), LocalDateTime.parse(m.group("date"), DTF));
        }
        ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_HANDLED_EVENTS, result);
    }

    static {
        AtomicLong index = new AtomicLong(1L);
        Stream.of("\u042f\u041d\u0412", "\u0424\u0415\u0412", "\u041c\u0410\u0420", "\u0410\u041f\u0420", "\u041c\u0410\u0419", "\u0418\u042e\u041d", "\u0418\u042e\u041b", "\u0410\u0412\u0413", "\u0421\u0415\u041d", "\u041e\u041a\u0422", "\u041d\u041e\u042f", "\u0414\u0415\u041a").forEach(v -> MONTHS.put(index.getAndIncrement(), (String)v));
        DTF = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.DAY_OF_MONTH, 2).appendText((TemporalField)ChronoField.MONTH_OF_YEAR, MONTHS).appendPattern("yy HH:mm:ss").toFormatter(new Locale("ru"));
    }
}

