/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.queue;

import com.gridnine.xtrip.common.gds.sirena.queue.SirenaQueueReservationReference;
import com.gridnine.xtrip.common.gds.sirena.queue.SirenaQueueWatchSettings;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.QueuePnrRemoveQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.StringUtils;

public class QueuePnrRemoveQueryBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SirenaQueueWatchSettings settings = (SirenaQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        SirenaQueueReservationReference ref = (SirenaQueueReservationReference)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCE);
        SirenaRequest<QueuePnrRemoveQuery> request = this.buildRequest(ref, settings);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, request);
    }

    private SirenaRequest<QueuePnrRemoveQuery> buildRequest(SirenaQueueReservationReference ref, SirenaQueueWatchSettings settings) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(ref, settings));
        request.setSecure(true);
        request.setPrivileged(true);
        return request;
    }

    private QueuePnrRemoveQuery buildQuery(SirenaQueueReservationReference ref, SirenaQueueWatchSettings settings) {
        QueuePnrRemoveQuery query = new QueuePnrRemoveQuery();
        query.setNum(settings.getNumber());
        query.setRegnum(ref.getRecordLocator());
        query.setTheirRegnum(ref.getTheirRegnum());
        if (!StringUtils.isBlank((String)settings.getSeance())) {
            QueuePnrRemoveQuery.RequestParams rp = new QueuePnrRemoveQuery.RequestParams();
            rp.setSeance(settings.getSeance());
            query.setRequestParams(rp);
        }
        return query;
    }
}

