/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.queue;

import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.ReleaseSeatsQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ReleaseSeatsQueryBuilder
extends BaseProcessor {
    private static final Set<String> STATUSES = new HashSet<String>(Arrays.asList("HX", "\u0425\u0425"));

    public void process(MessageContext ctx) throws Exception {
        ctx.removeObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        ReleaseSeatsQuery query = new ReleaseSeatsQuery();
        if (answer.getPnr().getSegments() != null && answer.getPnr().getSegments().getSegments() != null) {
            for (Pnr.Segments.Segment aSeg : answer.getPnr().getSegments().getSegments()) {
                if (!STATUSES.contains(aSeg.getStatus().getText())) continue;
                ReleaseSeatsQuery.Segment qSeg = new ReleaseSeatsQuery.Segment();
                qSeg.setCompany(aSeg.getCompany());
                qSeg.setFlight(aSeg.getFlight());
                qSeg.setDeparture(aSeg.getDeparture().getAirport());
                qSeg.setArrival(aSeg.getArrival().getAirport());
                qSeg.setDate(aSeg.getDeparture().getDate());
                qSeg.setId(aSeg.getId());
                query.getSegments().add(qSeg);
            }
        }
        if (!query.getSegments().isEmpty()) {
            for (Pnr.Passengers.Passenger aPas : answer.getPnr().getPassengers().getPassengers()) {
                ReleaseSeatsQuery.Passenger qPas = new ReleaseSeatsQuery.Passenger();
                qPas.setName(aPas.getName());
                qPas.setSurname(aPas.getSurname());
                qPas.setId(aPas.getId());
                query.getPassengers().add(qPas);
            }
            SirenaRequest request = new SirenaRequest();
            request.setQuery((AbstractSirenaQuery)query);
            request.setPrivileged(true);
            ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, (Object)request);
        }
    }
}

