/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.queue;

import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.GdsSegment;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.SirenaServerHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class SirenaBaseQueueWatchEventParser
extends BaseProcessor {
    private static final Set<String> UNCONFIRMED_SEGMENT_STATUS = Stream.of("\u041d\u041b", "\u0422\u0422", "\u041e\u041d", "\u041d\u0415", "\u041d\u0420").collect(Collectors.toSet());
    private static final Set<String> CHANGED_SEGMENT_STATUS = Stream.of("\u0422\u041a", "TK").collect(Collectors.toSet());
    private static final Set<String> CANCELLED_SEGMENT_STATUS = Stream.of("\u0423\u041d", "UN", "XX", "\u0425\u0425", "HX").collect(Collectors.toSet());

    public void process(MessageContext ctx) throws Exception {
        BaseQueueWatchEvent event = (BaseQueueWatchEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        if (answer.getPnr().getSegments() != null && answer.getPnr().getSegments().getSegments() != null) {
            for (Pnr.Segments.Segment s : answer.getPnr().getSegments().getSegments()) {
                GdsSegment seg = new GdsSegment();
                seg.setRecordNumber(Integer.parseInt(s.getId()));
                seg.setAirline(SirenaHelper.resolveNativeCode(Airline.class, (String)s.getCompany()));
                seg.setFlightNumber(s.getFlight());
                seg.setBookingClass(s.getClazz());
                seg.setDepartureDateTime(SirenaServerHelper.parseDate(s.getDeparture()));
                seg.setArrivalDateTime(SirenaServerHelper.parseDate(s.getArrival()));
                seg.setDepartureLocation(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)SirenaBaseQueueWatchEventParser.getLocationCode(s.getDeparture())));
                seg.setArrivalLocation(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)SirenaBaseQueueWatchEventParser.getLocationCode(s.getArrival())));
                seg.setSegmentStatus(s.getStatus().getText());
                seg.setSeatCount(Integer.parseInt(s.getSeatcount()));
                seg.setUnconfirmed(UNCONFIRMED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                seg.setChanged(CHANGED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                seg.setCancelled(CANCELLED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
                event.getGdsSegments().add(seg);
            }
        }
        event.setHasTickets(answer.getTickinfos() != null && !answer.getTickinfos().isEmpty());
    }

    private static String getLocationCode(Pnr.Segments.Segment.Location location) {
        if (!StringUtils.isBlank((String)location.getAirport())) {
            return location.getAirport();
        }
        return location.getCity();
    }
}

