/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.refundAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.Regnum;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.gds.sirena2000.model.SvcEmdRefundQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SvcEmdRefundQueryBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Regnum regnum = (Regnum)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.REGNUM);
        Product product = (Product)ctx.getObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCT);
        List<Product> products = product != null ? Collections.singletonList(product) : (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(regnum, products));
    }

    private SirenaRequest<SvcEmdRefundQuery> buildRequest(Regnum regnum, Collection<Product> products) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(regnum, products));
        request.setPrivileged(false);
        request.setSecure(false);
        return request;
    }

    private SvcEmdRefundQuery buildQuery(Regnum regnum, Collection<Product> products) {
        String[] gdsIds;
        SvcEmdRefundQuery query = new SvcEmdRefundQuery();
        Regnum queryRegnum = new Regnum();
        queryRegnum.setValue(regnum.getValue());
        queryRegnum.setVersion(regnum.getVersion());
        query.setRegnum(queryRegnum);
        for (String id : gdsIds = (String[])products.stream().map(Product::getGdsId).flatMap(ids -> Arrays.stream(ids.split(","))).toArray(String[]::new)) {
            Svc svc = new Svc();
            svc.setId(id);
            query.getSvc().add(svc);
        }
        return query;
    }
}

