/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.refundReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.McoPenaltyInfo;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.ProductFop;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.GetItinReceiptsDataAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.refundReservation.SirenaReceiptProcessor;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateMcoPenaltyDocumentsProcessor
extends BaseProcessor {
    private static final String BLANK_TYPE_CODE = "99A EMD";
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("\\d+\\.?\\d*");

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        GetItinReceiptsDataAnswer answer = (GetItinReceiptsDataAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        this.createDocuments(reservation, unsellFinanceDetails, answer, ctx);
    }

    private void createDocuments(Reservation reservation, UnsellFinanceDetails unsellFinanceDetails, GetItinReceiptsDataAnswer answer, MessageContext ctx) throws Exception {
        HashMap<String, Product> productMap = new HashMap<String, Product>();
        for (BaseProduct bp : reservation.getProducts()) {
            Product product = (Product)bp;
            productMap.put(product.getUid(), product);
        }
        Map<String, List<McoPenaltyInfo>> mcoMap = this.processResponseMCO(answer, ctx);
        for (String productUid : unsellFinanceDetails.getGdsDetails().keySet()) {
            Product product;
            String sn;
            if (!productMap.containsKey(productUid) || !mcoMap.containsKey(sn = (product = (Product)productMap.get(productUid)).getCarrierNumber() + product.getSystemNumber())) continue;
            Product refundProd = product.getNextProduct();
            for (McoPenaltyInfo penaltyInfo : mcoMap.get(sn)) {
                this.createMcoPenaltyDocument(product, refundProd, penaltyInfo);
            }
        }
    }

    private void createMcoPenaltyDocument(Product product, Product refundProd, McoPenaltyInfo penaltyInfo) throws Exception {
        Product mcoProduct = new Product();
        AirProductHelper.copy((Product)product, (Product)mcoProduct, (boolean)false);
        AirProductHelper.clearFops((Product)mcoProduct);
        AirProductHelper.clearContractRelations((Product)mcoProduct);
        product.getReservation().getProducts().add(mcoProduct);
        mcoProduct.getRelatedProducts().clear();
        mcoProduct.getRelatedProducts().add(refundProd);
        mcoProduct.setIssueDate(new Date());
        mcoProduct.setProductCategory(ProductCategory.MCO);
        mcoProduct.setMcoCategory(MCOCategory.PENALTY);
        mcoProduct.setCarrierNumber(penaltyInfo.getCode());
        mcoProduct.setSystemNumber(penaltyInfo.getNumber());
        mcoProduct.setBlankType(CreateMcoPenaltyDocumentsProcessor.createBlankType());
        mcoProduct.setPcc(penaltyInfo.getPcc());
        mcoProduct.setEndorsement(null);
        mcoProduct.setFareCalculationData(null);
        mcoProduct.setNextProduct(null);
        mcoProduct.setPreviousProduct(null);
        mcoProduct.getSegmentTariffs().clear();
        mcoProduct.getFares().clear();
        mcoProduct.getTaxes().clear();
        if (penaltyInfo.getEquivAmount() != null) {
            if (refundProd.getPenalty() != null) {
                if (refundProd.getPenalty().compareTo(penaltyInfo.getEquivAmount()) <= 0) {
                    refundProd.setPenalty(null);
                } else {
                    refundProd.setPenalty(refundProd.getPenalty().subtract(penaltyInfo.getEquivAmount()));
                }
            }
            ProductFare fare = new ProductFare();
            Money m = new Money();
            m.setCurrency(penaltyInfo.getCurrency());
            m.setValue(penaltyInfo.getAmount());
            fare.setBaseFare(m);
            fare.setEquivalentFare(penaltyInfo.getEquivAmount());
            mcoProduct.getFares().add(fare);
        }
        this.clearFees(mcoProduct);
        this.updateFops(mcoProduct, product);
        mcoProduct.setCompleted(false);
        mcoProduct.setChecked(false);
        mcoProduct.setContractRulesApplied(false);
        mcoProduct.getObFees().clear();
    }

    private static DictionaryReference<BlankType> createBlankType() {
        DictionaryCache cache = DictionaryCache.get();
        BlankType bt = (BlankType)cache.findByCode(BlankType.class, BLANK_TYPE_CODE);
        return bt != null ? bt.toReference() : null;
    }

    private void updateFops(Product refundProd, Product sellProd) {
        AirProductHelper.updateFops((Product)refundProd);
        List sellCR = AirProductHelper.getContractRelations((Product)sellProd);
        for (AirProductContractRelationData item : AirProductHelper.getContractRelations((Product)refundProd)) {
            AirProductContractRelationData sellRelation = AirProductHelper.findContractRelation((List)sellCR, (EntityReference)item.getDescription());
            PaymentType pt = null;
            if (sellRelation != null) {
                for (ProductFop fop : sellRelation.getFops()) {
                    if (!AirProductHelper.isServiceFop((ProductFop)fop)) continue;
                    pt = fop.getType();
                    break;
                }
            }
            for (ProductFop fop : item.getFops()) {
                if (!AirProductHelper.isServiceFop((ProductFop)fop)) continue;
                fop.setOperationDate(refundProd.getIssueDate());
                fop.setType(pt);
            }
        }
    }

    private void clearFees(Product product) {
        for (AirProductContractRelationData relation : AirProductHelper.getContractRelations((Product)product)) {
            relation.getCommissions().removeIf(commission -> commission.getCommissionProperties() != null && FeeProperties.class.equals((Object)commission.getCommissionProperties().getType()));
        }
    }

    private Map<String, List<McoPenaltyInfo>> processResponseMCO(GetItinReceiptsDataAnswer answer, MessageContext ctx) throws Exception {
        HashMap<String, List<McoPenaltyInfo>> mcoMap = new HashMap<String, List<McoPenaltyInfo>>();
        if (answer.getReceipts().getTexts() != null) {
            for (int i = 0; i < answer.getReceipts().getTexts().size(); ++i) {
                McoPenaltyInfo info;
                String data = new String(Base64.decode((String)answer.getReceipts().getTexts().get(i)), "cp866");
                SirenaReceiptProcessor processor = new SirenaReceiptProcessor(data);
                try {
                    info = processor.parseAsMcoPenalty();
                }
                catch (Throwable t) {
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"failed parsing mco from 'answer/get_itin_receipts_data/receipts/text[{0}]'", (Throwable)t, (Object[])new Object[]{i}));
                    continue;
                }
                info.setPcc((String)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER_PULT));
                CreateMcoPenaltyDocumentsProcessor.addInfoToMcoMap(info, mcoMap);
            }
        } else {
            for (GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm : answer.getReceipts().getTicketForms()) {
                McoPenaltyInfo info = new McoPenaltyInfo();
                info.setAmount(this.getMcoPenaltyAmount(ticketForm, false));
                info.setCode(CreateMcoPenaltyDocumentsProcessor.getAirlineCode(ticketForm.getEmdNum()));
                String curr = ticketForm.getCurr().trim();
                if ("\u0420\u0423\u0411".equalsIgnoreCase(curr) || "\u0420\u0423\u0411/RUB".equals(curr)) {
                    curr = "RUB";
                }
                info.setEquivAmount(this.getMcoPenaltyAmount(ticketForm, TextUtil.nonBlank((String)ticketForm.getEquivFarePd())));
                info.setCurrency(curr);
                info.setNumber(CreateMcoPenaltyDocumentsProcessor.getShortNumber(ticketForm.getEmdNum()));
                HashSet<String> conjTicks = new HashSet<String>();
                GetItinReceiptsDataAnswer.Receipts.TicketForm.ConjTicks ticks = ticketForm.getConjTicks();
                if (ticks != null && ticks.getConjTicks() != null) {
                    conjTicks.addAll(ticks.getConjTicks());
                }
                if (conjTicks.size() > 1) {
                    throw Xeption.forDeveloper((String)("several conjTicks with different numbers " + Arrays.toString(conjTicks.toArray())), (Object[])new Object[0]);
                }
                info.setRelatedProductNumber(conjTicks.isEmpty() ? "" : (String)conjTicks.stream().findAny().get());
                info.setPcc((String)ctx.getObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER_PULT));
                CreateMcoPenaltyDocumentsProcessor.addInfoToMcoMap(info, mcoMap);
            }
        }
        return mcoMap;
    }

    private static void addInfoToMcoMap(McoPenaltyInfo info, Map<String, List<McoPenaltyInfo>> mcoMap) {
        List<Object> list;
        if (mcoMap.containsKey(info.getRelatedProductNumber())) {
            list = mcoMap.get(info.getRelatedProductNumber());
        } else {
            list = new ArrayList();
            mcoMap.put(info.getRelatedProductNumber(), list);
        }
        list.add(info);
    }

    private BigDecimal getMcoPenaltyAmount(GetItinReceiptsDataAnswer.Receipts.TicketForm ticketForm, boolean equiv) {
        String amount = equiv ? CreateMcoPenaltyDocumentsProcessor.getAmount(ticketForm.getEquivFarePd()) : (ticketForm.getValue() != null ? ticketForm.getValue().trim() : CreateMcoPenaltyDocumentsProcessor.getAmount(ticketForm.getTotal()));
        return new BigDecimal(amount);
    }

    private static String getAmount(String ticketForm) {
        Matcher matcher = AMOUNT_PATTERN.matcher(ticketForm);
        if (matcher.find()) {
            return matcher.group();
        }
        throw Xeption.forDeveloper((String)"amount pattern not found", (Object[])new Object[0]);
    }

    private static String getAirlineCode(String fullNumber) {
        int idx = fullNumber.indexOf(32);
        if (idx < 0) {
            idx = 3;
        }
        return fullNumber.substring(0, idx);
    }

    private static String getShortNumber(String fullNumber) {
        int idx = fullNumber.indexOf(32);
        if (idx < 0) {
            idx = 2;
        }
        return fullNumber.substring(idx + 1);
    }
}

