/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.refundReservation;

import com.google.common.collect.Multimap;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PaymentExtAuthAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaModelHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.Tickinfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

public class FillUnsellFinanceDetailsWithGdsDetailsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        PaymentExtAuthAnswer answer = (PaymentExtAuthAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Map prodMap = (Map)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.PRODUCTS_MAP);
        Multimap infoMap = (Multimap)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.TICKETS_INFO_MAP);
        for (Map.Entry entry : prodMap.entrySet()) {
            String sysNo = (String)entry.getKey();
            Collection infos = infoMap.get((Object)sysNo);
            GdsProductRefexFinanceDetails gdsProductRefexFinanceDetails = (GdsProductRefexFinanceDetails)unsellFinanceDetails.getGdsDetails().get((Object)((Product)entry.getValue()).getUid());
            if (gdsProductRefexFinanceDetails == null) continue;
            Money baseFare = new Money();
            baseFare.setCurrency(DictHelper.getEquivCurrency());
            baseFare.setValue(BigDecimal.ZERO);
            gdsProductRefexFinanceDetails.setBaseFare(baseFare);
            gdsProductRefexFinanceDetails.setEquivalentFare(BigDecimal.ZERO);
            gdsProductRefexFinanceDetails.setPenalty(BigDecimal.ZERO);
            for (Tickinfo info : infos) {
                Pnr.Prices.Price price = SirenaModelHelper.getPrice(answer.getPnr(), info.getPassId(), info.getSegId());
                if (price == null) continue;
                if (price.getFare() != null) {
                    BigDecimal fareValue = new BigDecimal(price.getFare().getValue().getValue());
                    gdsProductRefexFinanceDetails.setEquivalentFare(gdsProductRefexFinanceDetails.getEquivalentFare().add(fareValue.negate()));
                    gdsProductRefexFinanceDetails.getBaseFare().setValue(gdsProductRefexFinanceDetails.getBaseFare().getValue().add(fareValue.negate()));
                }
                if (price.getTaxes() == null) continue;
                for (Pnr.Prices.Price.Taxes.Tax tax : price.getTaxes().getTaxes()) {
                    BigDecimal taxValue = new BigDecimal(tax.getValue());
                    if ("\u0428\u0422".equals(tax.getCode())) {
                        gdsProductRefexFinanceDetails.setPenalty(gdsProductRefexFinanceDetails.getPenalty().add(taxValue));
                        continue;
                    }
                    SimpleTax st = new SimpleTax();
                    st.setCode(tax.getCode());
                    st.setAmount(taxValue.negate());
                    gdsProductRefexFinanceDetails.getTaxes().add(st);
                }
            }
        }
    }
}

