/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.refundReservation;

import com.google.common.collect.HashMultimap;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Tickinfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.List;

public class GetTicketsInfoProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        HashMap<String, Product> prodMap = new HashMap<String, Product>();
        HashMultimap infoMap = HashMultimap.create();
        for (Tickinfo info : answer.getTickinfos()) {
            String sysNo = info.getTicknum();
            Product validProduct = this.findValidProductForVoid(reservation, sysNo);
            if (validProduct == null) {
                throw Xeption.forDeveloper((String)("\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 \u043d\u043e\u043c\u0435\u0440\u043e\u043c " + sysNo), (Object[])new Object[0]);
            }
            infoMap.put((Object)sysNo, (Object)info);
            prodMap.put(sysNo, validProduct);
        }
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.PNR, (Object)answer.getPnr());
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.TICKETS_INFO_MAP, (Object)infoMap);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.PRODUCTS_MAP, prodMap);
    }

    public Product findValidProductForVoid(Reservation reservation, String sysNo) {
        List prods = BookingHelper.findProductsByFullSystemNumber((String)sysNo, (BookingFile)reservation.getBookingFile());
        Product validProduct = null;
        for (Product prod : prods) {
            if (prod.getStatus() != ProductStatus.SELL || prod.getNextProduct() != null) continue;
            if (validProduct == null) {
                validProduct = prod;
                continue;
            }
            throw Xeption.forDeveloper((String)"\u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 {0} \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0432\u0430\u043b\u0438\u0434\u043d\u043e\u0433\u043e \u0434\u043b\u044f \u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (Object[])new Object[]{sysNo});
        }
        if (validProduct == null) {
            throw Xeption.forDeveloper((String)"\u0434\u043b\u044f \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u0430 {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432\u0430\u043b\u0438\u0434\u043d\u043e\u0433\u043e \u0434\u043b\u044f \u0432\u043e\u0439\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (Object[])new Object[]{sysNo});
        }
        return validProduct;
    }
}

