/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.refundReservation;

import com.gridnine.xtrip.common.gds.model.McoPenaltyInfo;
import com.gridnine.xtrip.common.model.Xeption;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SirenaReceiptProcessor {
    private final String data;
    private static final Pattern P_EMD_NUMBER = Pattern.compile("\u041d\u041e\u041c\u0415\u0420 EMD/EMD NUMBER[^0-9A-Z\u0410-\u042f]+([0-9A-Z\u0410-\u042f]{3})[ ]+([0-9]{10})");
    private static final Set<Pattern> PS_ISSUED_IN_CONNECTION_WITH = new HashSet<Pattern>();
    private static final Pattern P_AMOUNT_IN_FIGURES;
    private static final Pattern P_EQUIV_AMOUNT_PAID;

    public SirenaReceiptProcessor(String data) {
        this.data = data;
    }

    public McoPenaltyInfo parseAsMcoPenalty() {
        McoPenaltyInfo result = new McoPenaltyInfo();
        Matcher m = P_EMD_NUMBER.matcher(this.data);
        if (!m.find()) {
            throw Xeption.forDeveloper((String)"EMD_NUMBER not found in receipt", (Object[])new Object[0]);
        }
        result.setCode(m.group(1));
        result.setNumber(m.group(2));
        boolean issuedInConnectionWithFound = false;
        for (Pattern P_ISSUED_IN_CONNECTION_WITH : PS_ISSUED_IN_CONNECTION_WITH) {
            Matcher m2 = P_ISSUED_IN_CONNECTION_WITH.matcher(this.data);
            if (!m2.find()) continue;
            issuedInConnectionWithFound = true;
            result.setRelatedProductNumber(m2.group(1));
            break;
        }
        if (!issuedInConnectionWithFound) {
            throw Xeption.forDeveloper((String)"ISSUED_IN_CONNECTION_WITH not found in receipt", (Object[])new Object[0]);
        }
        Matcher m3 = P_AMOUNT_IN_FIGURES.matcher(this.data);
        if (!m3.find()) {
            throw Xeption.forDeveloper((String)"AMOUNT_IN_FIGURES not found in receipt", (Object[])new Object[0]);
        }
        result.setAmount(new BigDecimal(m3.group(2)));
        String currencyCode = m3.group(1);
        if ("\u0420\u0423\u0411".equals(currencyCode)) {
            currencyCode = "RUB";
        }
        result.setCurrency(currencyCode);
        if ("RUB".equals(result.getCurrency())) {
            result.setEquivAmount(result.getAmount());
        } else {
            m3 = P_EQUIV_AMOUNT_PAID.matcher(this.data);
            if (!m3.find()) {
                throw Xeption.forDeveloper((String)"EQUIV_AMOUNT_PAID not found in receipt", (Object[])new Object[0]);
            }
            result.setEquivAmount(new BigDecimal(m3.group(1)));
        }
        return result;
    }

    static {
        PS_ISSUED_IN_CONNECTION_WITH.add(Pattern.compile("\u0412\u042b\u0414\u0410\u041d \u0412\u041c\u0415\u0421\u0422\u0415 \u0421/ISSUED IN CONNECTION WITH[^0-9A-Z\u0410-\u042f]+([0-9A-Z\u0410-\u042f]{3}[0-9]{10})"));
        PS_ISSUED_IN_CONNECTION_WITH.add(Pattern.compile("\u0412\u042b\u0414\u0410\u041d \u0412\u041c\u0415\u0421\u0422\u0415 \u0421/\u041d\u041e\u041c\u0415\u0420 \u041a\u0423\u041f\\./ISSUED IN CONN\\. WITH/CPN NUMBER[^0-9A-Z\u0410-\u042f]+([0-9A-Z\u0410-\u042f]{3}[0-9]{10})"));
        P_AMOUNT_IN_FIGURES = Pattern.compile("\u0421\u0423\u041c\u041c\u0410 \u0426\u0418\u0424\u0420\u0410\u041c\u0418[^0-9]+([A-Z\u0410-\u042f]{3})[^A-Z\u0410-\u042f0-9]+([0-9\\.]+)");
        P_EQUIV_AMOUNT_PAID = Pattern.compile("\u042d\u041a\u0412.\u0412 \u0412\u0410\u041b\u042e\u0422\u0415 \u041f\u041b\u0410\u0422\u0415\u0416\u0410[^0-9]+([0-9\\.]+)");
    }
}

