/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.reports;

import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaReportRow;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaReportSegment;
import com.gridnine.xtrip.common.gds.stat.GDSStatEntry;
import com.gridnine.xtrip.common.gds.stat.TraceDataItem;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Element;

class SirenaReportPrepareHelper {
    SirenaReportPrepareHelper() {
    }

    static void prepareData(Map<String, Object> data, String batchId, String ... errorTexts) throws Exception {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        ReportBatchData batchData = new ReportBatchData();
        batchData.setBatchId(batchId);
        ArrayList<Message> messages = (ArrayList<Message>)data.get("key-messages");
        if (messages == null) {
            messages = new ArrayList<Message>();
            data.put("key-messages", messages);
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)GDSStatEntry.Property.gds.name(), (Object)GdsName.SIRENA));
        query.getCriteria().getCriterions().add(SearchCriterion.between((String)GDSStatEntry.Property.entryDate.name(), (Object)params.getPeriodBegin(), (Object)params.getPeriodEnd()));
        query.getCriteria().getCriterions().add(SearchCriterion.contains((String)GDSStatEntry.Property.transactionNames.name(), (Object)"BOOKING_CREATE"));
        ArrayList<SearchCriterion> textCriterions = new ArrayList<SearchCriterion>();
        for (String errorText : errorTexts) {
            textCriterions.add(SearchCriterion.ilike((String)GDSStatEntry.Property.errorMessage.name(), (String)errorText));
        }
        if (textCriterions.size() == 1) {
            query.getCriteria().getCriterions().add(textCriterions.get(0));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])textCriterions.toArray(new SearchCriterion[textCriterions.size()])));
        }
        query.getCriteria().getOrders().put(GDSStatEntry.Property.entryDate.name(), SortOrder.ASC);
        for (GDSStatEntry entry : LogicalStorage.get().getAssetStorage().search(GDSStatEntry.class, query).getData()) {
            try {
                batchData.getTickets().add(SirenaReportPrepareHelper.parse(entry));
            }
            catch (Exception ex) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0442\u0440\u043e\u0447\u043a\u0438 \u043e\u0442\u0447\u0435\u0442\u0430", (Throwable)ex, (Object[])new Object[0]));
            }
        }
        data.put("key-batch-data-list", Collections.singletonList(batchData));
    }

    private static SirenaReportRow parse(GDSStatEntry entry) throws Exception {
        Element[] segments;
        if (entry.getTrace().size() != 1) {
            throw new Exception("unexpected trace size: " + entry.getTrace().size());
        }
        Element transaction = DocumentBuilderHelper.parse((InputStream)new ByteArrayInputStream(((TraceDataItem)entry.getTrace().get(0)).getTraceData().getBytes())).getDocumentElement();
        SirenaReportRow row = new SirenaReportRow();
        row.setTransactionDatetime(transaction.getAttribute("date"));
        for (Element segment : segments = XmlUtil.getElements((Element)transaction, (String)"request/data/sirena/query/booking/segment")) {
            row.getSegments().add(SirenaReportPrepareHelper.parseSegment(segment));
        }
        row.setErrorCode(XHelper.readString((Element)transaction, (String)"response/data/sirena/answer/booking/error@code"));
        row.setErrorText(XHelper.readString((Element)transaction, (String)"response/data/sirena/answer/booking/error"));
        return row;
    }

    private static SirenaReportSegment parseSegment(Element segment) {
        SirenaReportSegment result = new SirenaReportSegment();
        result.setDeparture(XHelper.readString((Element)segment, (String)"departure"));
        result.setArrival(XHelper.readString((Element)segment, (String)"arrival"));
        result.setDate(XHelper.readString((Element)segment, (String)"date"));
        result.setSubclass(XHelper.readString((Element)segment, (String)"subclass"));
        result.setCompany(XHelper.readString((Element)segment, (String)"company"));
        result.setNum(XHelper.readString((Element)segment, (String)"num"));
        return result;
    }
}

