/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Commission;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AddAgentComissionQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class AddAgentComissionQueryBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        BigDecimal amount = null;
        Double rate = null;
        String currency = null;
        for (Product product : AirProductHelper.getAirProductsList((Reservation)reservation)) {
            Commission commission = BookingHelper.getTotalBspCommission((Product)product);
            if (currency == null) {
                currency = product.getGdsCurrency();
            } else if (!currency.equals(product.getGdsCurrency())) {
                throw Xeption.forDeveloper((String)String.format("ambiguous currency: %s & %s" + product.getGdsCurrency(), currency), (Object[])new Object[0]);
            }
            if (commission.getRate() != null) {
                if (rate != null && !commission.getRate().equals(rate)) {
                    throw Xeption.forDeveloper((String)String.format("ambiguous rate: %s & %s" + commission.getRate(), rate), (Object[])new Object[0]);
                }
                if (rate != null) continue;
                rate = commission.getRate();
                continue;
            }
            if (rate != null) {
                throw Xeption.forDeveloper((String)"amount rate mix", (Object[])new Object[0]);
            }
            if (amount == null) {
                amount = commission.getEquivalentAmount();
                continue;
            }
            amount = amount.add(commission.getEquivalentAmount());
        }
        AddAgentComissionQuery query = new AddAgentComissionQuery();
        query.setRegnum(SirenaHelper.getRecordLocator((Reservation)reservation));
        query.setSurname(SirenaHelper.getSurname((Reservation)reservation));
        AddAgentComissionQuery.AgentComission agentComission = new AddAgentComissionQuery.AgentComission();
        if (rate != null) {
            agentComission.setType("percent");
            agentComission.setValue(rate.toString());
        } else {
            agentComission.setType("sum");
            amount = amount.setScale((int)DictHelper.getCurrencyInfoByAnyCode((String)currency).getIataDecimalPlaces(), RoundingMode.UNNECESSARY);
            agentComission.setCurr(currency);
            agentComission.setValue(amount.toString());
        }
        query.setAgentComission(agentComission);
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)query);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, (Object)request);
    }
}

