/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.exceptions.DifferentSegmentsCountException;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CheckSegmentsCountProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Map<String, List<Product>> data = AirProductHelper.getAirProductsStream((Reservation)reservation).collect(Collectors.groupingBy(p -> p.getTraveller().getUid()));
        int gdsSegmentCounter = 0;
        if (answer.getPnr().getSegments() != null && answer.getPnr().getSegments().getSegments() != null) {
            gdsSegmentCounter = answer.getPnr().getSegments().getSegments().size();
        }
        for (List<Product> prodList : data.values()) {
            int midSegmentCounter = 0;
            midSegmentCounter = (int)prodList.stream().flatMap(product -> AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream()).map(Segment::getGdsId).distinct().count();
            if (midSegmentCounter == gdsSegmentCounter) continue;
            throw new DifferentSegmentsCountException();
        }
    }
}

