/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.PaymentExtAuthQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.StringUtils;

public class PaymentExtAuthFixPriceParametersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PaymentExtAuthQuery.RequestParams rp;
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        Fop fop = (Fop)ctx.getObject((Enum)IBusMidofficeContextKeys.FOP);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        PaymentExtAuthQuery query = (PaymentExtAuthQuery)request.getQuery();
        if (fop != null) {
            boolean hasNoCardVendor;
            boolean bl = hasNoCardVendor = fop.getCard() != null && fop.getCard().getVendor() == null;
            if (hasNoCardVendor) {
                ((SirenaGdsAccount)accountCtr.getEntity()).setFopCCreplacementCode("\u041f\u041a");
            }
            String sirenaPaymentType = SirenaHelper.paymentType2str((SirenaGdsAccount)((SirenaGdsAccount)accountCtr.getEntity()), (PaymentType)fop.getType(), (boolean)SirenaHelper.isBsp((Reservation)reservation));
            if (!StringUtils.isBlank((String)gdsParameters.getFopReplacementCode())) {
                sirenaPaymentType = gdsParameters.getFopReplacementCode();
            }
            PaymentExtAuthQuery.Paydoc paydoc = new PaymentExtAuthQuery.Paydoc();
            paydoc.setFormpay(sirenaPaymentType);
            if (!"\u041f\u041f".equals(sirenaPaymentType) && fop.getCard() != null && fop.getCard().getVendor() != null) {
                paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)fop.getCard().getVendor()));
            } else if ("\u041f\u041a".equals(sirenaPaymentType)) {
                paydoc.setType(SirenaHelper.cardVendor2str((CardVendor)CardVendor.VISA));
            }
            query.setPaydoc(paydoc);
        }
        if ((rp = query.getRequestParams()) == null) {
            rp = new PaymentExtAuthQuery.RequestParams();
            query.setRequestParams(rp);
        }
        rp.setTickSer(PaymentExtAuthFixPriceParametersProcessor.isEticket(reservation) ? "\u042d\u0411\u041c" : "N");
        PaymentExtAuthQuery.AnswerParams ap = query.getAnswerParams();
        if (ap == null) {
            ap = new PaymentExtAuthQuery.AnswerParams();
            query.setAnswerParams(ap);
        }
        ap.setShowPriceDetails(Boolean.TRUE);
    }

    private static boolean isEticket(Reservation reservation) {
        for (BaseProduct baseProduct : reservation.getProducts()) {
            if (!(baseProduct instanceof Product)) continue;
            Product ticket = (Product)baseProduct;
            BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(ticket.getBlankType());
            if (!(blankType != null ? blankType.getBlankCategory() != BlankCategory.ETICKET : !ticket.isEticket())) continue;
            return false;
        }
        return true;
    }
}

