/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.MCOReservationRequestStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.GDSRepriceHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.OrderAnswer;
import com.gridnine.xtrip.server.gds.sirena2000.model.Pnr;
import com.gridnine.xtrip.server.gds.sirena2000.model.SirenaModelHelper;
import com.gridnine.xtrip.server.gds.sirena2000.model.Svc;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class UpdateProductsAfterRepriceProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        OrderAnswer answer = (OrderAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        BigDecimal oldCost = UpdateProductsAfterRepriceProcessor.calculateCost(reservation);
        this.updatePrices(reservation, answer);
        BigDecimal newCost = UpdateProductsAfterRepriceProcessor.calculateCost(reservation);
        if (Math.abs(newCost.subtract(oldCost).doubleValue()) >= 0.01) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)"\u043f\u0440\u0438 \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f {0} \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u043e\u0441\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 c {1} \u043d\u0430 {2}", (Object[])new Object[]{SirenaHelper.getRecordLocator((Reservation)reservation), oldCost, newCost}));
        }
    }

    private void updatePrices(Reservation reservation, OrderAnswer answer) {
        ArrayList<Pnr.Prices.Price> mainProductPrices = new ArrayList<Pnr.Prices.Price>();
        HashMap mcoProductPrices = new HashMap();
        HashSet<String> svcIdsPriced = new HashSet<String>();
        for (Pnr.Prices.Price price : answer.getPnr().getPrices().getPrices()) {
            if (TextUtil.nonBlank((String)price.getSvcId())) {
                if (!mcoProductPrices.containsKey(price.getTicket())) {
                    mcoProductPrices.put(price.getTicket(), new ArrayList());
                }
                ((List)mcoProductPrices.get(price.getTicket())).add(price);
                svcIdsPriced.add(price.getSvcId());
                continue;
            }
            mainProductPrices.add(price);
        }
        for (BaseProduct bp : reservation.getProducts()) {
            Product prod = (Product)bp;
            prod.getFares().clear();
            prod.getTaxes().clear();
        }
        for (Pnr.Prices.Price price : mainProductPrices) {
            Collection<Product> prods = this.findProducts(reservation, price);
            Segment seg = this.findSegment(prods, price, answer);
            SegmentTariff st = null;
            Product theProd = null;
            block3: for (Product prod : prods) {
                for (SegmentTariff segtar : prod.getSegmentTariffs()) {
                    if (!segtar.getSegments().contains(seg)) continue;
                    st = segtar;
                    theProd = prod;
                    continue block3;
                }
            }
            if (theProd == null) {
                throw Xeption.forEndUser((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u043b\u0435\u0442\u043d\u044b\u0445 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0412\u043d\u0435\u0441\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0437\u0430\u043a\u0430\u0437 \u0438\u043b\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u044b\u043f\u0438\u0441\u043a\u0443 \u0432\u0440\u0443\u0447\u043d\u0443\u044e", (Object[])new Object[0]);
            }
            SirenaModelHelper.addFareAndTaxes(theProd, st, price);
            seg.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)price.getBaggage()));
            seg.setFareBasis(price.getFare().getCode());
            if (StringUtils.isBlank((String)price.getTourCode())) continue;
            theProd.setTourCode(price.getTourCode());
        }
        List mcoProductsToCheckIfPriced = GDSHelper.getProducts((Reservation)reservation, (ProductCategory[])new ProductCategory[]{ProductCategory.MCO});
        for (Product mcoPr : mcoProductsToCheckIfPriced) {
            List<String> idsToCheck = Arrays.asList(mcoPr.getGdsId().split(","));
            if (svcIdsPriced.containsAll(idsToCheck)) continue;
            mcoPr.setMcoReservationRequestStatus(MCOReservationRequestStatus.REJECTED);
            mcoPr.setStatus(ProductStatus.REJECT);
        }
        for (String ticketNumber : mcoProductPrices.keySet()) {
            Object price2;
            String svcGdsId = "";
            ArrayList<Segment> segments = new ArrayList<Segment>();
            for (Object price2 : (List)mcoProductPrices.get(ticketNumber)) {
                svcGdsId = TextUtil.isBlank((String)svcGdsId) ? ((Pnr.Prices.Price)price2).getSvcId() : svcGdsId + "," + ((Pnr.Prices.Price)price2).getSvcId();
            }
            Collection mcoProducts = GDSHelper.getProductsByGdsId((Reservation)reservation, (String)svcGdsId);
            price2 = ((List)mcoProductPrices.get(ticketNumber)).iterator();
            while (price2.hasNext()) {
                Pnr.Prices.Price price3 = (Pnr.Prices.Price)price2.next();
                Segment seg = this.findSegment(mcoProducts, price3, answer);
                segments.add(seg);
            }
            SegmentTariff st = null;
            Product theProd = null;
            block9: for (Product prod : mcoProducts) {
                for (SegmentTariff segtar : prod.getSegmentTariffs()) {
                    if (!segtar.getSegments().containsAll(segments)) continue;
                    st = segtar;
                    theProd = prod;
                    continue block9;
                }
            }
            if (theProd == null) {
                throw Xeption.forEndUser((String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u043b\u0435\u0442\u043d\u044b\u0445 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u043e\u0432 \u0432 \u0437\u0430\u043a\u0430\u0437\u0435 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u043c \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0412\u043d\u0435\u0441\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0432 \u0437\u0430\u043a\u0430\u0437 \u0438\u043b\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0438\u0442\u0435 \u0432\u044b\u043f\u0438\u0441\u043a\u0443 \u0432\u0440\u0443\u0447\u043d\u0443\u044e", (Object[])new Object[0]);
            }
            for (Pnr.Prices.Price price4 : (List)mcoProductPrices.get(ticketNumber)) {
                SirenaModelHelper.addFareAndTaxes(theProd, st, price4);
                Segment seg = this.findSvcSegment(theProd, price4, answer);
                seg.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)price4.getBaggage()));
                seg.setFareBasis(price4.getFare().getCode());
                if (StringUtils.isBlank((String)price4.getTourCode())) continue;
                theProd.setTourCode(price4.getTourCode());
            }
            if (theProd.getFares().size() <= 1) continue;
            this.removeFaresWithZeroPrice(theProd);
        }
    }

    private void removeFaresWithZeroPrice(Product product) {
        product.getFares().removeIf(productFare -> productFare.getEquivalentFare().compareTo(BigDecimal.ZERO) == 0);
    }

    private static BigDecimal calculateCost(Reservation reservation) {
        BigDecimal result = BigDecimal.ZERO;
        for (BaseProduct bp : reservation.getProducts()) {
            Product product = (Product)bp;
            result = result.add(BookingHelper.calculateProductPrice((BaseProduct)product, (ContractType)ContractType.VENDOR).getTotal());
            result = result.add(GDSRepriceHelper.getHiddenFee((Product)product));
        }
        return result;
    }

    private Segment findSegment(Collection<Product> prods, Pnr.Prices.Price price, OrderAnswer answer) {
        if (TextUtil.nonBlank((String)price.getSvcId())) {
            Svc svc = answer.getPnr().getSvcs().getSvcs().stream().filter(currentSvc -> price.getSvcId().equals(currentSvc.getId())).findFirst().get();
            return GDSHelper.findSegmentByGdsId(prods, (String)svc.getSegmentId());
        }
        return GDSHelper.findSegmentByGdsId(prods, (String)price.getSegmentId());
    }

    private Segment findSvcSegment(Product product, Pnr.Prices.Price price, OrderAnswer answer) {
        if (TextUtil.nonBlank((String)price.getSvcId())) {
            Svc svc = answer.getPnr().getSvcs().getSvcs().stream().filter(currentSvc -> price.getSvcId().equals(currentSvc.getId())).findFirst().get();
            return GDSHelper.findSegmentByGdsId((Product)product, (String)svc.getSegmentId());
        }
        return null;
    }

    private Collection<Product> findProducts(Reservation reservation, Pnr.Prices.Price price) {
        if (TextUtil.nonBlank((String)price.getSvcId())) {
            return GDSHelper.getProductsByGdsId((Reservation)reservation, (String)price.getSvcId());
        }
        return GDSHelper.getProductsByGdsId((Reservation)reservation, (String)price.getPassengerId());
    }
}

