/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flightFares;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AddAdditionalNonBrandedFaresFlightsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Map multicallResult = (Map)ctx.getMandatoryObject("FLIGHT_FARES_MULTICALL_RESULT");
        List<Flight> brandedFlights = this.getFlights(multicallResult, IBusGdsContextKeys.FLIGHTS);
        List<Flight> nonBrandedFlights = this.getFlights(multicallResult, IBusGdsContextKeys.ADDITIONAL_FLIGHTS);
        for (Flight nonBrandedFlight : nonBrandedFlights) {
            if (FlightHelper.isFlightAnyBranded((Flight)nonBrandedFlight)) continue;
            brandedFlights.add(nonBrandedFlight);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, brandedFlights);
    }

    private List<Flight> getFlights(Map<String, MessageContext> multicallResult, IBusGdsContextKeys key) {
        List flightsLists = multicallResult.values().stream().map(context -> (List)context.getObject((Enum)key)).filter(Objects::nonNull).collect(Collectors.toList());
        if (flightsLists.size() != 1) {
            throw Xeption.forDeveloper((String)("illegal count of flights lists: " + flightsLists.size()), (Object[])new Object[0]);
        }
        return (List)flightsLists.get(0);
    }
}

