/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flightFares;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.pricingRoute.PricingRouteHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Map;

public class PricingAddSegmentsProcessor
extends BaseProcessor {
    private boolean addSubclass;

    public void configure(Map<String, String> parameters) {
        this.addSubclass = MiscUtil.isTrue((String)parameters.get("add-subclass"));
    }

    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        int jointId = 0;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            for (FlightSegment fs : fst.getSegments()) {
                if (fs.isStarting()) {
                    ++jointId;
                }
                AbstractPricingQuery.Segment segment = new AbstractPricingQuery.Segment();
                segment.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)fs.getLocationBegin()));
                segment.setArrival(SirenaHelper.getNativeCode((DictionaryReference)fs.getLocationEnd()));
                segment.setDate(PricingRouteHelper.DF.format(fs.getDateBegin()));
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)fs.getAirline()));
                segment.setNum(fs.getFlightNumber());
                if (this.addSubclass) {
                    segment.setSubclass(fs.getBookingClass());
                }
                segment.setJointId(Integer.toString(jointId));
                ((AbstractPricingQuery)request.getQuery()).getSegments().add(segment);
            }
        }
    }
}

