/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flightFares;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseRoutingKeyProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.StringUtils;

public class SirenaIsFlightBrandedProvider
extends BaseRoutingKeyProvider {
    public String getRoutingKey(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        if (this.isBranded(flight)) {
            if ("\u04104".equals(SirenaHelper.getNativeCode((DictionaryReference)flight.getCarrier())) || "A4".equals(SirenaHelper.getNativeCode((DictionaryReference)flight.getCarrier()))) {
                return "both";
            }
            return "branded";
        }
        return "non-branded";
    }

    private boolean isBranded(Flight flight) {
        String monoBrand = null;
        DictionaryReference monoAirline = null;
        for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
            String brand = SirenaCustomPropertiesHelper.getBrand((FlightSegmentTariff)fst);
            if (StringUtils.isBlank((String)brand)) {
                return false;
            }
            if (monoBrand == null) {
                monoBrand = brand;
            } else if (!MiscUtil.equals((Object)monoBrand, (Object)brand)) {
                return false;
            }
            for (FlightSegment fs : fst.getSegments()) {
                if (monoAirline == null) {
                    monoAirline = fs.getAirline();
                    continue;
                }
                if (MiscUtil.equals((Object)monoAirline, (Object)fs.getAirline())) continue;
                return false;
            }
        }
        return true;
    }
}

