/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class ExcludeTariffVariationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (((SirenaGdsAccount)accountCtr.getEntity()).isExcludeTariffVariations()) {
            Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
            HashSet<String> flightKeys = new HashSet<String>();
            Iterator iter = flights.iterator();
            while (iter.hasNext()) {
                Flight flight = (Flight)iter.next();
                String key = this.buildKey(flight);
                if (flightKeys.add(key)) continue;
                iter.remove();
            }
        }
    }

    private String buildKey(Flight flight) {
        StringBuilder result = new StringBuilder();
        for (FlightSegmentTariff st : flight.getSegmentTariffs()) {
            for (FlightSegment seg : st.getSegments()) {
                if (result.length() > 0) {
                    result.append('-');
                }
                if (seg.getAirline() != null) {
                    result.append(seg.getAirline().getCode());
                }
                result.append(seg.getFlightNumber());
            }
        }
        return result.toString();
    }
}

