/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flights;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ClassOfServiceTable;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.HashMap;

public class FillClassOfServiceTableProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        ClassOfService serviceClass = fsp.getServiceClass();
        if (serviceClass == null) {
            this.log.error("Class of service is null, cancelling table update task.");
            return;
        }
        this.fillClassOfServiceTable(flights, serviceClass);
    }

    private void fillClassOfServiceTable(Collection<Flight> flights, ClassOfService classOfService) {
        HashMap<MiscUtil.Pair, ClassOfService> map = new HashMap<MiscUtil.Pair, ClassOfService>();
        for (Flight flight : flights) {
            for (FlightSegmentTariff fst : flight.getSegmentTariffs()) {
                for (FlightSegment fs : fst.getSegments()) {
                    map.put(new MiscUtil.Pair((Object)fs.getAirline(), (Object)fs.getBookingClass()), classOfService);
                }
            }
        }
        ClassOfServiceTable.fillTable(map);
    }
}

