/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.SpecialTariff;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.AbstractPricingQuery;
import com.gridnine.xtrip.server.gds.sirena2000.pricingRoute.PricingRouteHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class PricingAddSegmentsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        EntityReference specialTariffRef = (EntityReference)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SPECIAL_TARIFF);
        SpecialTariff specialTariff = specialTariffRef != null ? (SpecialTariff)EntityStorage.get().resolve(specialTariffRef).getEntity() : null;
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SirenaRequest request = (SirenaRequest)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST);
        DictionaryReference prevLocation = null;
        for (RouteSegment rs : fsp.getRoute()) {
            if (prevLocation != null && !prevLocation.equals((Object)rs.getLocationBegin())) {
                ((AbstractPricingQuery)request.getQuery()).getSegments().add(new AbstractPricingQuery.LandSegment());
            }
            AbstractPricingQuery.Segment segment = new AbstractPricingQuery.Segment();
            segment.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)rs.getLocationBegin()));
            segment.setArrival(SirenaHelper.getNativeCode((DictionaryReference)rs.getLocationEnd()));
            segment.setDate(PricingRouteHelper.DF.format(rs.getDate()));
            if (rs.getDepartureTimeBegin() != null) {
                LocalTime tb = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeBegin().intValue() * 60000L));
                segment.setTimeFrom(PricingRouteHelper.TF.print((ReadablePartial)tb));
            }
            if (rs.getDepartureTimeEnd() != null) {
                LocalTime te = LocalTime.fromMillisOfDay((long)((long)rs.getDepartureTimeEnd().intValue() * 60000L));
                segment.setTimeTill(PricingRouteHelper.TF.print((ReadablePartial)te));
            }
            if (fsp.getServiceClass() != ClassOfService.ECONOMY) {
                segment.setClazz(SirenaHelper.serviceClassToString((ClassOfService)fsp.getServiceClass()));
            }
            if (specialTariff != null) {
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)specialTariff.getAirline()));
            } else if (rs.getAirline() != null) {
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)rs.getAirline()));
            } else if (((SirenaGdsAccount)accountCtr.getEntity()).isSearchCityFilterEnabled()) {
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)((SirenaGdsAccount)accountCtr.getEntity()).getSearchCityFilterAirline()));
            } else if (fsp.getPreferredAirlines().size() == 1) {
                segment.setCompany(SirenaHelper.getNativeCode((DictionaryReference)((DictionaryReference)fsp.getPreferredAirlines().get(0))));
            }
            segment.setFlight(rs.getFlightNumber());
            segment.setDirect(fsp.isSkipConnected());
            ((AbstractPricingQuery)request.getQuery()).getSegments().add(segment);
            prevLocation = rs.getLocationEnd();
        }
    }
}

