/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.search.flights.split;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaCustomPropertiesHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class SplitFlightsTest
extends ModelTestBase {
    @Test
    public void testAncillaryFeesSplit() throws Exception {
        Flight flight = (Flight)this.loadXSerializable("Flight.xml", Flight.class);
        FlightHelper.fillMultiTicketBreakdown((Flight)flight, SirenaCustomPropertiesHelper::getTicket, SplitFlightsTest::getCarrier);
        Assert.assertEquals((long)2L, (long)flight.getMultiTicketBreakdown().size());
        HashSet expected = new HashSet(flight.getAncillaryFees());
        Set actual = flight.getMultiTicketBreakdown().stream().flatMap(item -> item.getAncillaryFees().stream()).collect(Collectors.toSet());
        Assert.assertEquals(expected, actual);
    }

    private static DictionaryReference<Airline> getCarrier(FlightSegmentTariff fst) {
        return SirenaHelper.resolveNativeCode(Airline.class, (String)SirenaCustomPropertiesHelper.getValidatingCompany((FlightSegmentTariff)fst));
    }
}

