/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.searchSchedule;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.ScheduleSearchParameters;
import com.gridnine.xtrip.common.gds.sirena2000.AbstractSirenaQuery;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.ScheduleQuery;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.format.DateTimeFormatter;

public class SearchScheduleRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ScheduleSearchParameters parameters = (ScheduleSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SCHEDULE_SEARCH_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        ctx.putObject((Enum)IBusGdsSirenaContextKeys.SIRENA_REQUEST, this.buildRequest(parameters, salesContext));
    }

    private SirenaRequest<ScheduleQuery> buildRequest(ScheduleSearchParameters parameters, SalesContext salesContext) {
        SirenaRequest request = new SirenaRequest();
        request.setQuery((AbstractSirenaQuery)this.buildQuery(parameters, salesContext));
        request.setSecure(false);
        request.setPrivileged(false);
        return request;
    }

    private ScheduleQuery buildQuery(ScheduleSearchParameters parameters, SalesContext salesContext) {
        ScheduleQuery query = new ScheduleQuery();
        if (parameters.getLocationBegin() != null) {
            query.setDeparture(SirenaHelper.getNativeCode((DictionaryReference)parameters.getLocationBegin()));
        }
        if (parameters.getLocationEnd() != null) {
            query.setArrival(SirenaHelper.getNativeCode((DictionaryReference)parameters.getLocationEnd()));
        }
        if (parameters.getAirline() != null) {
            ScheduleQuery.Company company = new ScheduleQuery.Company();
            company.setValue(SirenaHelper.getNativeCode((DictionaryReference)parameters.getAirline()));
            query.setCompany(company);
        }
        DateTimeFormatter fmTime = DateTimeFormatter.ofPattern("HH:mm");
        if (parameters.getTimeStart() != null) {
            query.setTimeFrom(parameters.getTimeStart().format(fmTime));
        }
        if (parameters.getTimeEnd() != null) {
            query.setTimeTill(parameters.getTimeEnd().format(fmTime));
        }
        query.setDirect(parameters.isDirectOnly());
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("dd.MM.yy");
        if (parameters.getDate() != null) {
            query.setDate(parameters.getDate().format(fmt));
        }
        if (parameters.getDateEnd() != null) {
            query.setDate2(parameters.getDateEnd().format(fmt));
        } else {
            query.setDate2(parameters.getDate().format(fmt));
        }
        ScheduleQuery.AnswerParams ap = new ScheduleQuery.AnswerParams();
        ap.setMarkCityport(Boolean.TRUE);
        ap.setFullDate(Boolean.TRUE);
        ap.setShowEt(Boolean.TRUE);
        query.setAnswerParams(ap);
        return query;
    }
}

