/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sirena2000.searchSchedule;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.ScheduleFlight;
import com.gridnine.xtrip.common.gds.model.ScheduleFlightSegment;
import com.gridnine.xtrip.common.gds.model.ScheduleSearchParameters;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaHelper;
import com.gridnine.xtrip.common.gds.sirena2000.model.SirenaGdsAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.IBusGdsSirenaContextKeys;
import com.gridnine.xtrip.server.gds.sirena2000.model.ScheduleAnswer;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class SearchScheduleResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ScheduleFlight sf;
        ScheduleSearchParameters parameters = (ScheduleSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.SCHEDULE_SEARCH_PARAMETERS);
        ScheduleAnswer answer = (ScheduleAnswer)ctx.getMandatoryObject((Enum)IBusGdsSirenaContextKeys.SIRENA_ANSWER);
        ArrayList<ScheduleFlight> result = (ArrayList<ScheduleFlight>)ctx.getObject((Enum)IBusGdsContextKeys.SCHEDULE_FLIGHTS);
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (result == null) {
            result = new ArrayList<ScheduleFlight>();
            ctx.putObject((Enum)IBusGdsContextKeys.SCHEDULE_FLIGHTS, result);
        }
        if (answer.getFlights() != null) {
            for (ScheduleAnswer.Flight flight : answer.getFlights()) {
                sf = new ScheduleFlight();
                result.add(sf);
                sf.setGds(((SirenaGdsAccount)accountCtr.getEntity()).getGds());
                ScheduleFlightSegment segment = this.parseSegment(flight, answer);
                sf.getSegments().add(segment);
            }
        }
        if (!parameters.isDirectOnly() && answer.getFlightses() != null) {
            for (ScheduleAnswer.Flights flights : answer.getFlightses()) {
                sf = new ScheduleFlight();
                result.add(sf);
                sf.setGds(((SirenaGdsAccount)accountCtr.getEntity()).getGds());
                for (ScheduleAnswer.Flight flight : flights.getFlights()) {
                    ScheduleFlightSegment segment = this.parseSegment(flight, answer);
                    sf.getSegments().add(segment);
                }
            }
        }
    }

    private ScheduleFlightSegment parseSegment(ScheduleAnswer.Flight flight, ScheduleAnswer answer) {
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        LocalDate dateBegin = LocalDate.parse(answer.getDate(), DateTimeFormatter.ofPattern("dd.MM.yyyy"));
        ScheduleFlightSegment segment = new ScheduleFlightSegment();
        segment.setAirline(SirenaHelper.resolveNativeCode(Airline.class, (String)flight.getCompany()));
        segment.setFlightNumber(flight.getNum());
        segment.setLocationBegin(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)flight.getOrigin(), (LocationType)LocationType.AIRPORT));
        segment.setLocationEnd(SirenaHelper.resolveNativeCode(GeoLocation.class, (String)flight.getDestination(), (LocationType)LocationType.AIRPORT));
        segment.setBoard(SirenaHelper.resolveNativeCode(Aircraft.class, (String)flight.getAirplane()));
        String flightTime = flight.getFlightTime();
        if (flightTime != null) {
            int colonIndex = flightTime.indexOf(58);
            Duration flightDuration = Duration.ofHours(Long.parseLong(flightTime.substring(0, colonIndex))).plusMinutes(Long.parseLong(flightTime.substring(colonIndex + 1)));
            segment.setTravelDuration(Integer.valueOf((int)flightDuration.toMinutes()));
        }
        LocalDateTime departureDateTime = LocalTime.parse(flight.getDepttime().getValue(), timeFormatter).atDate(dateBegin);
        Integer depShift = flight.getDepttime().getDayshift();
        if (depShift != null) {
            departureDateTime = departureDateTime.plusDays(depShift.intValue());
        }
        segment.setStartTime(departureDateTime.toLocalTime());
        segment.setStartDate(departureDateTime.toLocalDate());
        LocalDateTime arrivalDateTime = LocalTime.parse(flight.getArrvtime().getValue(), timeFormatter).atDate(dateBegin);
        Integer arrvShift = flight.getArrvtime().getDayshift();
        if (arrvShift != null) {
            arrivalDateTime = arrivalDateTime.plusDays(arrvShift.intValue());
        }
        segment.setEndTime(arrivalDateTime.toLocalTime());
        segment.setEndDate(arrivalDateTime.toLocalDate());
        segment.setDateDelta(Period.between(departureDateTime.toLocalDate(), arrivalDateTime.toLocalDate()).getDays());
        if (flight.getPeriod() != null) {
            String periodDays;
            String periodEnd;
            DateTimeFormatter periodFm = DateTimeFormatter.ofPattern("dd.MM.[yyyy][yy]");
            String periodBegin = flight.getPeriod().getBegin();
            if (!StringUtils.isBlank((String)periodBegin)) {
                segment.setOperationStartDate(LocalDate.parse(periodBegin, periodFm));
            }
            if (!StringUtils.isBlank((String)(periodEnd = flight.getPeriod().getEnd()))) {
                segment.setOperationEndDate(LocalDate.parse(periodEnd, periodFm));
            }
            if (!StringUtils.isBlank((String)(periodDays = flight.getPeriod().getDays()))) {
                for (int i = 0; i < periodDays.length(); ++i) {
                    String dayNum = periodDays.substring(i, i + 1);
                    DayOfWeek day = DayOfWeek.of(Integer.parseInt(dayNum));
                    segment.getOperationDays().add(day);
                }
            }
        }
        if (flight.getClasses() != null) {
            Integer one = 1;
            if (one.equals(flight.getClasses().getEconom())) {
                segment.getAvailableClasses().add(ClassOfService.ECONOMY);
            }
            if (one.equals(flight.getClasses().getBusiness())) {
                segment.getAvailableClasses().add(ClassOfService.BUSINESS);
            }
            if (one.equals(flight.getClasses().getFirst())) {
                segment.getAvailableClasses().add(ClassOfService.FIRST);
            }
        }
        return segment;
    }
}

